/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl;

import io.crate.data.Input;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.engine.aggregation.AggregationFunction;
import io.crate.memory.MemoryManager;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.NumericType;
import java.math.BigDecimal;
import org.elasticsearch.Version;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class NumericMinAggregation
extends AggregationFunction<BigDecimal, BigDecimal> {
    public static final String NAME = "min";
    public static final Signature SIGNATURE = Signature.builder("min", FunctionType.AGGREGATE).argumentTypes(DataTypes.NUMERIC.getTypeSignature()).returnType(DataTypes.NUMERIC.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build();
    private static final long INIT_BIG_DECIMAL_SIZE = NumericType.size(BigDecimal.ZERO);
    private final Signature signature;
    private final BoundSignature boundSignature;
    private final DataType<BigDecimal> returnType;

    public static void register(Functions.Builder builder) {
        builder.add(SIGNATURE, NumericMinAggregation::new);
    }

    @VisibleForTesting
    private NumericMinAggregation(Signature signature, BoundSignature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        DataType<?> argumentType = boundSignature.argTypes().get(0);
        assert (argumentType.id() == DataTypes.NUMERIC.id());
        this.returnType = argumentType;
    }

    @Override
    @Nullable
    public BigDecimal newState(RamAccounting ramAccounting, Version indexVersionCreated, Version minNodeInCluster, MemoryManager memoryManager) {
        ramAccounting.addBytes(INIT_BIG_DECIMAL_SIZE);
        return null;
    }

    @Override
    public BigDecimal iterate(RamAccounting ramAccounting, MemoryManager memoryManager, BigDecimal state, Input<?> ... args) throws CircuitBreakingException {
        BigDecimal value = this.returnType.implicitCast(args[0].value());
        if (value != null) {
            if (state != null) {
                if (state.compareTo(value) >= 0) {
                    state = value;
                }
            } else {
                state = value;
            }
        }
        return state;
    }

    @Override
    public BigDecimal reduce(RamAccounting ramAccounting, BigDecimal state1, BigDecimal state2) {
        if (state1 == null) {
            return state2;
        }
        if (state2 == null) {
            return state1;
        }
        if (state1.compareTo(state2) < 0) {
            return state1;
        }
        return state2;
    }

    @Override
    public BigDecimal terminatePartial(RamAccounting ramAccounting, BigDecimal state) {
        if (state != null) {
            ramAccounting.addBytes(NumericType.size(state));
        }
        return state;
    }

    @Override
    public DataType<?> partialType() {
        return this.returnType;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public BoundSignature boundSignature() {
        return this.boundSignature;
    }
}

