/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl.average.numeric;

import io.crate.Streamer;
import io.crate.execution.engine.aggregation.impl.average.numeric.NumericAverageState;
import io.crate.execution.engine.aggregation.impl.util.BigDecimalValueWrapper;
import io.crate.types.DataType;
import io.crate.types.NumericType;
import java.io.IOException;
import java.math.BigDecimal;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class NumericAverageStateType
extends DataType<NumericAverageState>
implements Streamer<NumericAverageState> {
    public static final int ID = 1026;
    public static final long INIT_SIZE = NumericType.size(BigDecimal.ZERO) + 8L;
    public static final NumericAverageStateType INSTANCE = new NumericAverageStateType();

    @Override
    public int id() {
        return 1026;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.CUSTOM;
    }

    @Override
    public String getName() {
        return "numeric_average_state";
    }

    @Override
    public Streamer<NumericAverageState> streamer() {
        return this;
    }

    @Override
    public NumericAverageState sanitizeValue(Object value) {
        return (NumericAverageState)value;
    }

    @Override
    public int compare(NumericAverageState val1, NumericAverageState val2) {
        if (val1 == null) {
            return -1;
        }
        return val1.compareTo(val2);
    }

    @Override
    public NumericAverageState readValueFrom(StreamInput in) throws IOException {
        NumericType type = new NumericType(in);
        return new NumericAverageState<BigDecimalValueWrapper>(new BigDecimalValueWrapper(type.readValueFrom(in)), in.readVLong());
    }

    @Override
    public void writeValueTo(StreamOutput out, NumericAverageState v) throws IOException {
        NumericType type = new NumericType(v.sum.value().precision(), v.sum.value().scale());
        type.writeTo(out);
        type.writeValueTo(out, v.sum.value());
        out.writeVLong(v.count);
    }

    @Override
    public long valueBytes(NumericAverageState value) {
        throw new UnsupportedOperationException("valueSize is not implemented on NumericAverageStateType");
    }
}

