/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.stats;

import io.crate.breaker.ConcurrentRamAccounting;
import io.crate.data.breaker.RamAccounting;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.ToLongFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.breaker.CircuitBreaker;

public final class RamAccountingQueue<T>
implements Queue<T> {
    private static final Logger LOGGER = LogManager.getLogger(RamAccountingQueue.class);
    private final Queue<T> delegate;
    private final RamAccounting ramAccounting;
    private final ToLongFunction<T> getElementSize;
    private final CircuitBreaker breaker;
    private final AtomicBoolean exceeded;

    public RamAccountingQueue(Queue<T> delegate, CircuitBreaker breaker, ToLongFunction<T> getElementSize) {
        this.delegate = delegate;
        this.breaker = breaker;
        this.getElementSize = getElementSize;
        this.ramAccounting = new ConcurrentRamAccounting(breaker::addWithoutBreaking, bytes -> breaker.addWithoutBreaking(-bytes), breaker.getName(), 0);
        this.exceeded = new AtomicBoolean(false);
    }

    private static String contextId() {
        return "RamAccountingQueue[" + String.valueOf(UUIDs.dirtyUUID()) + "]";
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public boolean add(T t) {
        return this.delegate.add(t);
    }

    @Override
    public boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.delegate.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.delegate.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.delegate.removeAll(c);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean offer(T o) {
        long elementSize = this.getElementSize.applyAsLong(o);
        this.ramAccounting.addBytes(elementSize);
        if (this.exceededBreaker() && this.exceeded.compareAndSet(false, true)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Memory limit for breaker [{}] was exceeded. Queue [{}] is cleared.", (Object)this.breaker.getName(), (Object)RamAccountingQueue.contextId());
            }
            this.release();
            this.ramAccounting.addBytes(elementSize);
            this.exceeded.set(false);
        }
        return this.delegate.offer(o);
    }

    @Override
    public T remove() {
        return this.delegate.remove();
    }

    @Override
    public T poll() {
        return this.delegate.poll();
    }

    @Override
    public T element() {
        return this.delegate.element();
    }

    @Override
    public T peek() {
        return this.delegate.peek();
    }

    public void release() {
        this.delegate.clear();
        this.ramAccounting.release();
    }

    public boolean exceededBreaker() {
        return this.breaker.getUsed() >= this.breaker.getLimit();
    }
}

