/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.distribution.merge;

import io.crate.data.Row;
import io.crate.data.breaker.RowAccounting;
import io.crate.execution.engine.distribution.merge.KeyIterable;
import io.crate.execution.engine.distribution.merge.PagingIterator;
import org.jetbrains.annotations.VisibleForTesting;

public class RamAccountingPageIterator<TKey>
implements PagingIterator<TKey, Row> {
    @VisibleForTesting
    final PagingIterator<TKey, Row> delegatePagingIterator;
    private final RowAccounting<Row> rowAccounting;

    public RamAccountingPageIterator(PagingIterator<TKey, Row> delegatePagingIterator, RowAccounting<Row> rowAccounting) {
        this.delegatePagingIterator = delegatePagingIterator;
        this.rowAccounting = rowAccounting;
    }

    @Override
    public void merge(Iterable<? extends KeyIterable<TKey, Row>> keyIterables) {
        for (KeyIterable<TKey, Row> iterable : keyIterables) {
            for (Row row : iterable) {
                this.rowAccounting.accountForAndMaybeBreak((Object)row);
            }
        }
        this.delegatePagingIterator.merge(keyIterables);
    }

    @Override
    public void finish() {
        this.delegatePagingIterator.finish();
    }

    @Override
    public TKey exhaustedIterable() {
        return this.delegatePagingIterator.exhaustedIterable();
    }

    @Override
    public Iterable<Row> repeat() {
        return this.delegatePagingIterator.repeat();
    }

    @Override
    public boolean hasNext() {
        return this.delegatePagingIterator.hasNext();
    }

    @Override
    public Row next() {
        return (Row)this.delegatePagingIterator.next();
    }
}

