/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.fetch;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntObjectHashMap;
import io.crate.common.collections.Lists;
import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.data.UnsafeArrayRow;
import io.crate.execution.engine.fetch.FetchId;
import io.crate.execution.engine.fetch.ReaderBucket;
import io.crate.expression.BaseImplementationSymbolVisitor;
import io.crate.expression.InputRow;
import io.crate.expression.symbol.FetchReference;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.TransactionContext;
import io.crate.planner.node.fetch.FetchSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;

public final class FetchRows {
    private final int[] fetchIdPositions;
    private final UnsafeArrayRow inputRow;
    private final Row output;
    private final IntObjectHashMap<UnsafeArrayRow> fetchedRows;
    private final ArrayList<Object[]> nullRows;

    public static FetchRows create(TransactionContext txnCtx, NodeContext nodeCtx, final Map<RelationName, FetchSource> fetchSourceByTable, List<Symbol> outputSymbols) {
        IntArrayList fetchIdPositions = new IntArrayList();
        ArrayList<Object[]> nullRows = new ArrayList<Object[]>();
        final IntObjectHashMap fetchedRows = new IntObjectHashMap();
        for (FetchSource fetchSource : fetchSourceByTable.values()) {
            Object[] nullRow = new Object[fetchSource.references().size()];
            for (InputColumn ic : fetchSource.fetchIdCols()) {
                fetchIdPositions.add(ic.index());
                nullRows.add(nullRow);
                fetchedRows.put(ic.index(), (Object)new UnsafeArrayRow());
            }
        }
        final UnsafeArrayRow inputRow = new UnsafeArrayRow();
        BaseImplementationSymbolVisitor<Void> visitor = new BaseImplementationSymbolVisitor<Void>(txnCtx, nodeCtx){

            @Override
            public Input<?> visitInputColumn(InputColumn inputColumn, Void context) {
                int idx = inputColumn.index();
                return () -> inputRow.get(idx);
            }

            @Override
            public Input<?> visitFetchReference(FetchReference fetchReference, Void context) {
                Reference ref = fetchReference.ref();
                UnsafeArrayRow row = (UnsafeArrayRow)fetchedRows.get(fetchReference.fetchId().index());
                int posInFetchedRow = ((FetchSource)fetchSourceByTable.get(ref.ident().tableIdent())).references().indexOf(ref);
                return () -> row.get(posInFetchedRow);
            }
        };
        List outputExpressions = Lists.map(outputSymbols, arg_0 -> FetchRows.lambda$create$0(visitor, arg_0));
        return new FetchRows(fetchIdPositions, outputExpressions, inputRow, (IntObjectHashMap<UnsafeArrayRow>)fetchedRows, nullRows);
    }

    public FetchRows(IntArrayList fetchIdPositions, List<Input<?>> outputExpressions, UnsafeArrayRow inputRow, IntObjectHashMap<UnsafeArrayRow> fetchedRows, ArrayList<Object[]> nullRows) {
        this.fetchedRows = fetchedRows;
        this.nullRows = nullRows;
        this.fetchIdPositions = fetchIdPositions.toArray();
        this.output = new InputRow(outputExpressions);
        this.inputRow = inputRow;
    }

    public Row updatedOutputRow(Object[] incomingCells, IntFunction<ReaderBucket> getReaderBucket) {
        for (int i = 0; i < this.fetchIdPositions.length; ++i) {
            int fetchIdPos = this.fetchIdPositions[i];
            Long fetchId = (Long)incomingCells[fetchIdPos];
            UnsafeArrayRow fetchedRow = (UnsafeArrayRow)this.fetchedRows.get(fetchIdPos);
            if (fetchId == null) {
                fetchedRow.cells(this.nullRows.get(i));
                continue;
            }
            int readerId = FetchId.decodeReaderId(fetchId);
            int docId = FetchId.decodeDocId(fetchId);
            ReaderBucket readerBucket = getReaderBucket.apply(readerId);
            Object[] cells = readerBucket.get(docId);
            assert (cells != null) : "Must have cells in readerBucket docId=" + docId + ", readerId=" + readerId;
            fetchedRow.cells(cells);
        }
        this.inputRow.cells(incomingCells);
        return this.output;
    }

    public int[] fetchIdPositions() {
        return this.fetchIdPositions;
    }

    private static /* synthetic */ Input lambda$create$0(1 visitor, Symbol x) {
        return (Input)x.accept(visitor, null);
    }
}

