/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.fetch;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.cursors.IntCursor;
import io.crate.breaker.CellsSizeEstimator;
import io.crate.data.Bucket;
import io.crate.data.Row;
import io.crate.data.breaker.RamAccounting;
import io.crate.expression.symbol.Symbols;
import io.crate.planner.node.fetch.FetchSource;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;

class ReaderBucket {
    private final IntObjectHashMap<Object[]> docs = new IntObjectHashMap();
    private final RamAccounting ramAccounting;
    private final CellsSizeEstimator estimateCellsSize;
    private IntArrayList sortedDocs;

    ReaderBucket(RamAccounting ramAccounting, FetchSource fetchSource) {
        this.ramAccounting = ramAccounting;
        this.estimateCellsSize = CellsSizeEstimator.forColumns(Symbols.typeView(fetchSource.references()));
    }

    void require(int doc) {
        this.docs.putIfAbsent(doc, null);
    }

    Object[] get(int doc) {
        return (Object[])this.docs.get(doc);
    }

    IntArrayList sortedDocs() {
        if (this.sortedDocs == null) {
            int[] keys = this.docs.keys().toArray();
            Arrays.sort(keys);
            this.sortedDocs = new IntArrayList(keys.length);
            this.sortedDocs.add(keys);
        }
        return this.sortedDocs;
    }

    long fetched(Bucket bucket) {
        assert (bucket.size() == this.docs.size()) : String.format(Locale.ENGLISH, "requested %d docs but got %d", this.docs.size(), bucket.size());
        assert (this.sortedDocs != null) : "sortedDocs() must have been called before fetched()";
        Iterator rowIterator = bucket.iterator();
        long bytesAccounted = 0L;
        for (IntCursor cursor : this.sortedDocs) {
            Object[] cells = ((Row)rowIterator.next()).materialize();
            bytesAccounted += this.accountMemory(cells);
            this.docs.put(cursor.value, (Object)cells);
        }
        this.sortedDocs = null;
        assert (!rowIterator.hasNext()) : "no more rows should exist";
        return bytesAccounted;
    }

    private long accountMemory(Object[] cells) {
        long bytes = this.estimateCellsSize.estimateSize(cells);
        this.ramAccounting.addBytes(bytes);
        return bytes;
    }

    public boolean isEmpty() {
        return this.docs.isEmpty();
    }
}

