/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.fetch;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntObjectMap;
import io.crate.Streamer;
import io.crate.action.FutureActionListener;
import io.crate.data.Bucket;
import io.crate.data.breaker.BlockBasedRamAccounting;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.engine.fetch.FetchOperation;
import io.crate.execution.engine.fetch.NodeFetchRequest;
import io.crate.execution.engine.fetch.NodeFetchResponse;
import io.crate.execution.support.ActionExecutor;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.jetbrains.annotations.VisibleForTesting;

public class TransportFetchOperation
implements FetchOperation {
    private static final Function<NodeFetchResponse, IntObjectMap<? extends Bucket>> GET_FETCHED = NodeFetchResponse::fetched;
    private final ActionExecutor<NodeFetchRequest, NodeFetchResponse> fetchNodeAction;
    private final Map<String, ? extends IntObjectMap<Streamer<?>[]>> nodeIdToReaderIdToStreamers;
    private final UUID jobId;
    private final int fetchPhaseId;
    private final RamAccounting ramAccounting;

    public TransportFetchOperation(ActionExecutor<NodeFetchRequest, NodeFetchResponse> fetchNodeAction, Map<String, ? extends IntObjectMap<Streamer<?>[]>> nodeIdToReaderIdToStreamers, UUID jobId, int fetchPhaseId, RamAccounting ramAccounting) {
        this.fetchNodeAction = fetchNodeAction;
        this.nodeIdToReaderIdToStreamers = nodeIdToReaderIdToStreamers;
        this.jobId = jobId;
        this.fetchPhaseId = fetchPhaseId;
        this.ramAccounting = ramAccounting;
    }

    @Override
    public CompletableFuture<IntObjectMap<? extends Bucket>> fetch(String nodeId, IntObjectMap<IntArrayList> toFetch, boolean closeContext) {
        FutureActionListener listener = new FutureActionListener();
        return ((CompletableFuture)this.fetchNodeAction.execute(new NodeFetchRequest(nodeId, this.jobId, this.fetchPhaseId, closeContext, toFetch, this.nodeIdToReaderIdToStreamers.get(nodeId), TransportFetchOperation.ramAccountingForIncomingResponse(this.ramAccounting, toFetch, closeContext))).whenComplete((BiConsumer)listener)).thenApply(GET_FETCHED);
    }

    @VisibleForTesting
    static RamAccounting ramAccountingForIncomingResponse(RamAccounting ramAccounting, IntObjectMap<? extends IntContainer> toFetch, boolean closeContext) {
        if (toFetch.isEmpty() && closeContext) {
            return RamAccounting.NO_ACCOUNTING;
        }
        return new BlockBasedRamAccounting(usedBytes -> {
            RamAccounting ramAccounting2 = ramAccounting;
            synchronized (ramAccounting2) {
                ramAccounting.addBytes(usedBytes);
            }
        }, 0x200000);
    }
}

