/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.join;

import io.crate.breaker.TypedCellsAccounting;
import io.crate.concurrent.CompletionListenable;
import io.crate.data.BatchIterator;
import io.crate.data.CapturingRowConsumer;
import io.crate.data.FilteringBatchIterator;
import io.crate.data.Paging;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.data.breaker.RamAccounting;
import io.crate.data.breaker.RowAccounting;
import io.crate.data.join.AntiJoinNLBatchIterator;
import io.crate.data.join.CombinedRow;
import io.crate.data.join.CrossJoinBlockNLBatchIterator;
import io.crate.data.join.CrossJoinNLBatchIterator;
import io.crate.data.join.ElementCombiner;
import io.crate.data.join.FullOuterJoinNLBatchIterator;
import io.crate.data.join.LeftJoinNLBatchIterator;
import io.crate.data.join.RightJoinNLBatchIterator;
import io.crate.data.join.SemiJoinNLBatchIterator;
import io.crate.execution.engine.join.RamBlockSizeCalculator;
import io.crate.sql.tree.JoinType;
import io.crate.types.DataType;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.LongToIntFunction;
import java.util.function.Predicate;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.jetbrains.annotations.VisibleForTesting;

public class NestedLoopOperation
implements CompletionListenable {
    private final CapturingRowConsumer leftConsumer;
    private final CapturingRowConsumer rightConsumer;
    private final RowConsumer resultConsumer;

    public NestedLoopOperation(int numLeftCols, int numRightCols, RowConsumer nlResultConsumer, Predicate<Row> joinPredicate, JoinType joinType, CircuitBreaker circuitBreaker, RamAccounting ramAccounting, List<DataType<?>> leftSideColumnTypes, long estimatedRowsSizeLeft, long estimatedNumberOfRowsLeft, boolean blockNestedLoop) {
        this.resultConsumer = nlResultConsumer;
        this.leftConsumer = new CapturingRowConsumer(nlResultConsumer.requiresScroll(), nlResultConsumer.completionFuture());
        this.rightConsumer = new CapturingRowConsumer(true, nlResultConsumer.completionFuture());
        CompletableFuture.allOf(this.leftConsumer.capturedBatchIterator(), this.rightConsumer.capturedBatchIterator()).whenComplete((result, failure) -> {
            if (failure == null) {
                BatchIterator<Row> nlIterator = NestedLoopOperation.createNestedLoopIterator((BatchIterator<Row>)((BatchIterator)this.leftConsumer.capturedBatchIterator().join()), numLeftCols, (BatchIterator<Row>)((BatchIterator)this.rightConsumer.capturedBatchIterator().join()), numRightCols, joinType, joinPredicate, circuitBreaker, ramAccounting, leftSideColumnTypes, estimatedRowsSizeLeft, estimatedNumberOfRowsLeft, blockNestedLoop);
                nlResultConsumer.accept(nlIterator, null);
            } else {
                nlResultConsumer.accept(null, failure);
            }
        });
    }

    public CompletableFuture<?> completionFuture() {
        return this.resultConsumer.completionFuture();
    }

    public RowConsumer leftConsumer() {
        return this.leftConsumer;
    }

    public RowConsumer rightConsumer() {
        return this.rightConsumer;
    }

    @VisibleForTesting
    static BatchIterator<Row> createNestedLoopIterator(BatchIterator<Row> left, int leftNumCols, BatchIterator<Row> right, int rightNumCols, JoinType joinType, Predicate<Row> joinCondition, CircuitBreaker circuitBreaker, RamAccounting ramAccounting, List<DataType<?>> leftSideColumnTypes, long estimatedRowsSizeLeft, long estimatedNumberOfRowsLeft, boolean blockNestedLoop) {
        CombinedRow combiner = new CombinedRow(leftNumCols, rightNumCols);
        switch (joinType) {
            case CROSS: {
                return NestedLoopOperation.buildCrossJoinBatchIterator(left, right, combiner, circuitBreaker, ramAccounting, leftSideColumnTypes, estimatedRowsSizeLeft, blockNestedLoop);
            }
            case INNER: {
                return new FilteringBatchIterator(NestedLoopOperation.buildCrossJoinBatchIterator(left, right, combiner, circuitBreaker, ramAccounting, leftSideColumnTypes, estimatedRowsSizeLeft, blockNestedLoop), joinCondition);
            }
            case LEFT: {
                return new LeftJoinNLBatchIterator(left, right, (ElementCombiner)combiner, joinCondition);
            }
            case RIGHT: {
                return new RightJoinNLBatchIterator(left, right, (ElementCombiner)combiner, joinCondition);
            }
            case FULL: {
                return new FullOuterJoinNLBatchIterator(left, right, (ElementCombiner)combiner, joinCondition);
            }
            case SEMI: {
                return new SemiJoinNLBatchIterator(left, right, (ElementCombiner)combiner, joinCondition);
            }
            case ANTI: {
                return new AntiJoinNLBatchIterator(left, right, (ElementCombiner)combiner, joinCondition);
            }
        }
        throw new AssertionError((Object)("Invalid joinType: " + String.valueOf(joinType)));
    }

    private static BatchIterator<Row> buildCrossJoinBatchIterator(BatchIterator<Row> left, BatchIterator<Row> right, CombinedRow combiner, CircuitBreaker circuitBreaker, RamAccounting ramAccounting, List<DataType<?>> leftSideColumnTypes, long estimatedRowsSizeLeft, boolean blockNestedLoop) {
        if (blockNestedLoop) {
            RamBlockSizeCalculator blockSizeCalculator = new RamBlockSizeCalculator(Paging.PAGE_SIZE, circuitBreaker, estimatedRowsSizeLeft);
            TypedCellsAccounting rowAccounting = new TypedCellsAccounting(leftSideColumnTypes, ramAccounting, 0);
            return new CrossJoinBlockNLBatchIterator(left, right, (ElementCombiner)combiner, (LongToIntFunction)blockSizeCalculator, (RowAccounting)rowAccounting);
        }
        return new CrossJoinNLBatchIterator(left, right, (ElementCombiner)combiner);
    }
}

