/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.pipeline;

import io.crate.data.BatchIterator;
import io.crate.data.LimitingBatchIterator;
import io.crate.data.Projector;
import io.crate.data.Row;
import io.crate.data.SkippingBatchIterator;

public class LimitAndOffsetProjector
implements Projector {
    private final int offset;
    private final int limit;

    public LimitAndOffsetProjector(int limit, int offset) {
        if (limit < 0) {
            throw new IllegalArgumentException("Invalid LIMIT: value must be >= 0; got: " + limit);
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Invalid OFFSET: value must be >= 0; got: " + offset);
        }
        this.limit = limit;
        this.offset = offset;
    }

    public BatchIterator<Row> apply(BatchIterator<Row> batchIterator) {
        if (batchIterator == null) {
            return null;
        }
        if (this.offset > 0) {
            batchIterator = new SkippingBatchIterator(batchIterator, this.offset);
        }
        return LimitingBatchIterator.newInstance(batchIterator, (int)this.limit);
    }

    public boolean providesIndependentScroll() {
        return false;
    }
}

