/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.profile;

import io.crate.execution.support.NodeRequest;
import java.io.IOException;
import java.util.UUID;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportRequest;

public class CollectProfileRequest
extends TransportRequest {
    private final UUID jobId;

    public static NodeRequest<CollectProfileRequest> of(String nodeId, UUID jobId) {
        return new NodeRequest<CollectProfileRequest>(nodeId, new CollectProfileRequest(jobId));
    }

    private CollectProfileRequest(UUID jobId) {
        this.jobId = jobId;
    }

    public UUID jobId() {
        return this.jobId;
    }

    CollectProfileRequest(StreamInput in) throws IOException {
        super(in);
        this.jobId = new UUID(in.readLong(), in.readLong());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.jobId.getMostSignificantBits());
        out.writeLong(this.jobId.getLeastSignificantBits());
    }
}

