/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.jobs;

import java.io.IOException;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.search.profile.Timer;
import org.elasticsearch.search.profile.query.ProfileWeight;
import org.elasticsearch.search.profile.query.QueryProfileBreakdown;
import org.elasticsearch.search.profile.query.QueryProfiler;
import org.elasticsearch.search.profile.query.QueryTimingType;

public class InstrumentedIndexSearcher
extends Engine.Searcher {
    private final QueryProfiler profiler;

    public InstrumentedIndexSearcher(Engine.Searcher delegate, QueryProfiler profiler) {
        super(delegate.source(), delegate.getIndexReader(), delegate.getQueryCache(), delegate.getQueryCachingPolicy(), delegate::close);
        this.profiler = profiler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Weight createWeight(Query query, ScoreMode scoreMode, float boost) throws IOException {
        Weight weight;
        QueryProfileBreakdown profile = this.profiler.getProfileBreakdown(query);
        Timer timer = profile.getTimer(QueryTimingType.CREATE_WEIGHT);
        timer.start();
        try {
            weight = super.createWeight(query, scoreMode, boost);
        }
        finally {
            timer.stop();
            this.profiler.pollLast();
        }
        return new ProfileWeight(query, weight, profile);
    }
}

