/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.support;

import io.crate.common.unit.TimeValue;
import io.crate.exceptions.SQLExceptions;
import java.util.Iterator;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;

public class RetryListener<TResp>
implements ActionListener<TResp> {
    private static final Logger LOGGER = LogManager.getLogger(RetryListener.class);
    private final ScheduledExecutorService scheduler;
    private final ActionListener<TResp> delegate;
    private final Iterator<TimeValue> delay;
    private final Runnable retryCommand;

    public RetryListener(ScheduledExecutorService scheduler, Consumer<ActionListener<TResp>> command, ActionListener<TResp> delegate, Iterable<TimeValue> backOffPolicy) {
        this.scheduler = scheduler;
        this.delegate = delegate;
        this.delay = backOffPolicy.iterator();
        this.retryCommand = () -> command.accept(this);
    }

    @Override
    public void onResponse(TResp response) {
        this.delegate.onResponse(response);
    }

    @Override
    public void onFailure(Exception e) {
        Throwable throwable = SQLExceptions.unwrap(e);
        if (this.shouldRetry(throwable) && this.delay.hasNext()) {
            long currentDelay = this.delay.next().millis();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Received " + String.valueOf(throwable.getClass()) + ", will retry again in {}ms", (Object)currentDelay);
            }
            this.scheduler.schedule(this.retryCommand, currentDelay, TimeUnit.MILLISECONDS);
        } else {
            this.delegate.onFailure(e);
        }
    }

    protected boolean shouldRetry(Throwable throwable) {
        EsRejectedExecutionException rejected;
        return throwable instanceof EsRejectedExecutionException && !(rejected = (EsRejectedExecutionException)throwable).isExecutorShutdown();
    }
}

