/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression;

import io.crate.data.Input;
import io.crate.execution.engine.collect.CollectExpression;
import java.util.List;
import java.util.RandomAccess;

public final class ExpressionsInput<TRow, TResult> {
    private final Input<TResult> input;
    private final List<? extends CollectExpression<TRow, ?>> expressions;

    public ExpressionsInput(Input<TResult> input, List<? extends CollectExpression<TRow, ?>> expressions) {
        assert (expressions instanceof RandomAccess) : "expressions must be a RandomAccess list to avoid iterator allocations";
        this.input = input;
        this.expressions = expressions;
    }

    public TResult value(TRow row) {
        for (int i = 0; i < this.expressions.size(); ++i) {
            this.expressions.get(i).setNextRow(row);
        }
        return (TResult)this.input.value();
    }

    public String toString() {
        return "ExpressionsInput{input=" + String.valueOf(this.input) + "}";
    }
}

