/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.operator.any;

import io.crate.expression.operator.EqOperator;
import io.crate.expression.operator.any.AnyOperator;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.Reference;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.sql.tree.ComparisonExpression;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;

public final class AnyEqOperator
extends AnyOperator<Object> {
    public static String NAME = "any_" + ComparisonExpression.Type.EQUAL.getValue();

    AnyEqOperator(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    boolean matches(Object probe, Object candidate) {
        return this.leftType.compare(probe, candidate) == 0;
    }

    @Override
    protected Query refMatchesAnyArrayLiteral(Function any, Reference probe, Literal<?> candidates, LuceneQueryBuilder.Context context) {
        String columnName = probe.storageIdent();
        DataType<?> type = probe.valueType();
        DataType<?> innerType = ArrayType.unnest(type);
        if (ArrayType.dimensions(candidates.valueType()) > 1) {
            return AnyEqOperator.termsAndGenericFilter(any, probe, candidates.value(), context);
        }
        List<?> nonNullValues = AnyEqOperator.filterNullValues(candidates);
        if (nonNullValues.isEmpty()) {
            return new MatchNoDocsQuery("Cannot match unless there is at least one non-null candidate");
        }
        return EqOperator.termsQuery(columnName, innerType, nonNullValues, probe.hasDocValues(), probe.indexType());
    }

    @Override
    protected Query literalMatchesAnyArrayRef(Function any, Literal<?> probe, Reference candidates, LuceneQueryBuilder.Context context) {
        if (DataTypes.isArray(probe.valueType())) {
            return AnyEqOperator.termsAndGenericFilter(any, candidates, probe.value(), context);
        }
        return EqOperator.fromPrimitive(ArrayType.unnest(candidates.valueType()), candidates.storageIdent(), probe.value(), candidates.hasDocValues(), candidates.indexType());
    }

    private static Query termsAndGenericFilter(Function function, Reference candidates, Object candidate, LuceneQueryBuilder.Context context) {
        ArrayList terms = new ArrayList();
        AnyEqOperator.gatherLeafs((Iterable)candidate, terms::add);
        Query termsQuery = EqOperator.termsQuery(candidates.storageIdent(), ArrayType.unnest(candidates.valueType()), terms, candidates.hasDocValues(), candidates.indexType());
        Query genericFunctionFilter = LuceneQueryBuilder.genericFunctionFilter(function, context);
        if (termsQuery == null) {
            return genericFunctionFilter;
        }
        return new BooleanQuery.Builder().add(termsQuery, BooleanClause.Occur.MUST).add(genericFunctionFilter, BooleanClause.Occur.FILTER).build();
    }

    private static void gatherLeafs(Iterable<?> toIterable, Consumer<? super Object> consumeLeaf) {
        for (Object o : toIterable) {
            if (o instanceof Iterable) {
                Iterable nestedIterable = (Iterable)o;
                AnyEqOperator.gatherLeafs(nestedIterable, consumeLeaf);
                continue;
            }
            if (o instanceof Object[]) {
                AnyEqOperator.gatherLeafs(Arrays.asList((Object[])o), consumeLeaf);
                continue;
            }
            consumeLeaf.accept(o);
        }
    }
}

