/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.doc.blob;

import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.collect.NestableCollectExpression;
import io.crate.expression.reference.ReferenceResolver;
import io.crate.metadata.Reference;
import java.io.File;
import java.util.Map;

public class BlobReferenceResolver
implements ReferenceResolver<CollectExpression<File, ?>> {
    public static final BlobReferenceResolver INSTANCE = new BlobReferenceResolver();
    private static final String DIGEST = "digest";
    private static final String LAST_MODIFIED = "last_modified";
    private static final Map<String, ExpressionBuilder> EXPRESSION_BUILDER = Map.of("digest", () -> NestableCollectExpression.forFunction(File::getName), "last_modified", () -> NestableCollectExpression.forFunction(File::lastModified));

    private BlobReferenceResolver() {
    }

    @Override
    public CollectExpression<File, ?> getImplementation(Reference refInfo) {
        assert ("blob".equals(refInfo.ident().tableIdent().schema())) : "schema name must be 'blob";
        ExpressionBuilder builder = EXPRESSION_BUILDER.get(refInfo.column().name());
        if (builder != null) {
            return builder.create();
        }
        return null;
    }

    static interface ExpressionBuilder {
        public CollectExpression<File, ?> create();
    }
}

