/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.doc.lucene;

import io.crate.common.collections.Maps;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.PartitionName;
import io.crate.metadata.Reference;
import java.util.List;
import java.util.Map;

public interface PartitionValueInjector {
    public Map<String, Object> injectValues(Map<String, Object> var1);

    public static PartitionValueInjector create(String indexName, List<Reference> partitionColumns) {
        if (partitionColumns.isEmpty()) {
            return m -> m;
        }
        PartitionName partitionName = PartitionName.fromIndexOrTemplate(indexName);
        if (partitionName.values().size() != partitionColumns.size()) {
            throw new IllegalArgumentException("Partition values " + String.valueOf(partitionName.values()) + " from index " + indexName + " must match partition columns " + String.valueOf(partitionColumns));
        }
        return input -> {
            for (int i = 0; i < partitionColumns.size(); ++i) {
                ColumnIdent columnIdent = ((Reference)partitionColumns.get(i)).column();
                Maps.mergeInto((Map)input, (String)columnIdent.name(), columnIdent.path(), (Object)partitionName.values().get(i));
            }
            return input;
        };
    }
}

