/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.doc.lucene;

import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.elasticsearch.common.bytes.BytesArray;

public final class SourceFieldVisitor
extends StoredFieldVisitor {
    private boolean done = false;
    private BytesArray source;

    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) {
        if (fieldInfo.name.equals("_source")) {
            this.done = true;
            return StoredFieldVisitor.Status.YES;
        }
        return this.done ? StoredFieldVisitor.Status.STOP : StoredFieldVisitor.Status.NO;
    }

    public void binaryField(FieldInfo fieldInfo, byte[] value) {
        assert ("_source".equals(fieldInfo.name)) : "Must only receive a source field";
        this.source = new BytesArray(value);
    }

    public void reset() {
        this.done = false;
        this.source = null;
    }

    public BytesArray source() {
        return this.source;
    }
}

