/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.check.node;

import io.crate.expression.reference.sys.check.SysCheck;
import io.crate.expression.reference.sys.check.node.AbstractSysNodeCheck;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.gateway.GatewayService;

@Singleton
public class RecoveryExpectedNodesSysCheck
extends AbstractSysNodeCheck {
    private final ClusterService clusterService;
    private final Settings settings;
    static final int ID = 1;
    private static final String DESCRIPTION = "It has been detected that the 'gateway.expected_data_nodes' setting (or the deprecated 'gateway.recovery_after_nodes' setting) is not configured or it does not match the actual number of (data) nodes in the cluster.";

    @Inject
    public RecoveryExpectedNodesSysCheck(ClusterService clusterService, Settings settings) {
        super(1, DESCRIPTION, SysCheck.Severity.MEDIUM);
        this.clusterService = clusterService;
        this.settings = settings;
    }

    @Override
    public boolean isValid() {
        int actualNodes = this.clusterService.state().nodes().getDataNodes().size();
        int expectedNodes = GatewayService.EXPECTED_DATA_NODES_SETTING.get(this.settings);
        if (expectedNodes == -1) {
            actualNodes = this.clusterService.state().nodes().getSize();
            expectedNodes = GatewayService.EXPECTED_NODES_SETTING.get(this.settings);
        }
        return RecoveryExpectedNodesSysCheck.validate(actualNodes, expectedNodes);
    }

    private static boolean validate(int actualNodes, int expectedNodes) {
        return actualNodes == 1 || actualNodes == expectedNodes;
    }
}

