/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.operation;

import io.crate.expression.reference.sys.job.ContextLog;
import io.crate.expression.reference.sys.operation.OperationContext;
import java.util.UUID;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.jetbrains.annotations.Nullable;

public class OperationContextLog
implements ContextLog,
Accountable {
    @Nullable
    private final String errorMessage;
    private final long ended;
    private final int id;
    private final UUID jobId;
    private final String name;
    private final long started;
    private final long usedBytes;

    public OperationContextLog(OperationContext operationContext, @Nullable String errorMessage) {
        this.id = operationContext.id();
        this.jobId = operationContext.jobId();
        this.name = operationContext.name();
        this.started = operationContext.started();
        this.usedBytes = operationContext.usedBytes();
        this.errorMessage = errorMessage;
        this.ended = System.currentTimeMillis();
    }

    public int id() {
        return this.id;
    }

    public UUID jobId() {
        return this.jobId;
    }

    public String name() {
        return this.name;
    }

    public long started() {
        return this.started;
    }

    @Override
    public long ended() {
        return this.ended;
    }

    public long usedBytes() {
        return this.usedBytes;
    }

    @Nullable
    public String errorMessage() {
        return this.errorMessage;
    }

    public long ramBytesUsed() {
        long size = 0L;
        size += 32L;
        size += this.errorMessage == null ? 0L : (long)this.errorMessage.length();
        size += 60L;
        return RamUsageEstimator.alignObjectSize((long)(size += (long)this.name.length()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationContextLog that = (OperationContextLog)o;
        if (this.id != that.id) {
            return false;
        }
        return this.jobId.equals(that.jobId);
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + this.jobId.hashCode();
        return result;
    }

    public String toString() {
        return "OperationContextLog{errorMessage='" + this.errorMessage + "', id=" + this.id + ", jobId=" + String.valueOf(this.jobId) + ", name='" + this.name + "', usedBytes=" + this.usedBytes + "}";
    }
}

