/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.TypeSignature;
import java.util.ArrayList;
import java.util.List;

public class ArrayCatFunction
extends Scalar<List<Object>, List<Object>> {
    public static final String NAME = "array_cat";

    public static void register(Functions.Builder module) {
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(TypeSignature.parse("array(E)"), TypeSignature.parse("array(E)")).returnType(TypeSignature.parse("array(E)")).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.NOTNULL).typeVariableConstraints(TypeVariableConstraint.typeVariable("E")).build(), ArrayCatFunction::new);
    }

    ArrayCatFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    @SafeVarargs
    public final List<Object> evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<List<Object>> ... args) {
        DataType innerType = ((ArrayType)this.boundSignature.returnType()).innerType();
        ArrayList<Object> resultList = new ArrayList<Object>();
        int nullCnt = 0;
        for (Input<List<Object>> arg : args) {
            List values = (List)arg.value();
            if (values == null) {
                ++nullCnt;
                continue;
            }
            for (Object value : values) {
                resultList.add(innerType.sanitizeValue(value));
            }
        }
        if (nullCnt == args.length) {
            return null;
        }
        return resultList;
    }
}

