/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.expression.scalar.array.ArrayArgumentValidators;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.List;
import java.util.Objects;

public class ArrayPositionFunction
extends Scalar<Integer, List<Object>> {
    public static final String NAME = "array_position";

    public ArrayPositionFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
        ArrayArgumentValidators.ensureInnerTypeIsNotUndefined(boundSignature.argTypes(), signature.getName().name());
    }

    public static void register(Functions.Builder builder) {
        builder.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(TypeSignature.parse("array(T)"), TypeSignature.parse("T")).returnType(DataTypes.INTEGER.getTypeSignature()).typeVariableConstraints(TypeVariableConstraint.typeVariable("T")).features(Scalar.Feature.DETERMINISTIC).build(), ArrayPositionFunction::new);
        builder.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(TypeSignature.parse("array(T)"), TypeSignature.parse("T"), DataTypes.INTEGER.getTypeSignature()).returnType(DataTypes.INTEGER.getTypeSignature()).typeVariableConstraints(TypeVariableConstraint.typeVariable("T")).features(Scalar.Feature.DETERMINISTIC).build(), ArrayPositionFunction::new);
    }

    @Override
    public Integer evaluate(TransactionContext txnCtx, NodeContext nodeContext, Input<List<Object>>[] args) {
        List elements = (List)args[0].value();
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        Object targetValue = args[1].value();
        Integer beginIndex = 0;
        if (args.length > 2) {
            beginIndex = this.getBeginPosition(args[2].value(), elements.size());
        }
        if (beginIndex == null) {
            return null;
        }
        for (int i = beginIndex.intValue(); i < elements.size(); ++i) {
            Object element = elements.get(i);
            if (!Objects.equals(targetValue, element)) continue;
            return i + 1;
        }
        return null;
    }

    private Integer getBeginPosition(Object position, int elementsSize) {
        if (position == null) {
            return 0;
        }
        int beginPosition = (Integer)position;
        if (beginPosition < 1 || beginPosition > elementsSize) {
            return null;
        }
        return beginPosition - 1;
    }
}

