/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import java.util.function.BinaryOperator;

public final class BinaryScalar<T>
extends Scalar<T, T> {
    private final BinaryOperator<T> func;
    private final DataType<T> type;

    public BinaryScalar(BinaryOperator<T> func, Signature signature, BoundSignature boundSignature, DataType<T> type) {
        super(signature, boundSignature);
        assert (signature.hasFeature(Scalar.Feature.STRICTNULL)) : "A BinaryScalar is NULLABLE by definition";
        assert (boundSignature.argTypes().stream().allMatch(t -> t.id() == type.id())) : "All bound argument types of the signature must match the type argument";
        this.func = func;
        this.type = type;
    }

    @Override
    public T evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<T>[] args) {
        T arg0Value = this.type.sanitizeValue(args[0].value());
        if (arg0Value == null) {
            return null;
        }
        T arg1Value = this.type.sanitizeValue(args[1].value());
        if (arg1Value == null) {
            return null;
        }
        try {
            return (T)this.func.apply(arg0Value, arg1Value);
        }
        catch (ArithmeticException ae) {
            throw new IllegalArgumentException(ae.getMessage(), ae);
        }
    }
}

