/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.List;

public class CollectionCountFunction
extends Scalar<Long, List<Object>> {
    public static final String NAME = "collection_count";

    public static void register(Functions.Builder builder) {
        builder.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(TypeSignature.parse("array(E)")).returnType(DataTypes.LONG.getTypeSignature()).typeVariableConstraints(TypeVariableConstraint.typeVariable("E")).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), CollectionCountFunction::new);
    }

    private CollectionCountFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    @SafeVarargs
    public final Long evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<List<Object>> ... args) {
        List argArray = (List)args[0].value();
        if (argArray == null) {
            return null;
        }
        return argArray.size();
    }
}

