/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.role.Roles;
import io.crate.types.DataTypes;
import java.util.EnumSet;
import java.util.List;
import org.joda.time.Period;

public class DateBinFunction
extends Scalar<Long, Object> {
    public static final String NAME = "date_bin";

    public static void register(Functions.Builder module) {
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.INTERVAL.getTypeSignature(), DataTypes.TIMESTAMPZ.getTypeSignature(), DataTypes.TIMESTAMPZ.getTypeSignature()).returnType(DataTypes.TIMESTAMPZ.getTypeSignature()).features(EnumSet.of(Scalar.Feature.DETERMINISTIC, Scalar.Feature.COMPARISON_REPLACEMENT, Scalar.Feature.STRICTNULL)).build(), DateBinFunction::new);
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.INTERVAL.getTypeSignature(), DataTypes.TIMESTAMP.getTypeSignature(), DataTypes.TIMESTAMP.getTypeSignature()).returnType(DataTypes.TIMESTAMP.getTypeSignature()).features(EnumSet.of(Scalar.Feature.DETERMINISTIC, Scalar.Feature.COMPARISON_REPLACEMENT, Scalar.Feature.STRICTNULL)).build(), DateBinFunction::new);
    }

    private DateBinFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    public Scalar<Long, Object> compile(List<Symbol> arguments, String currentUser, Roles roles) {
        Input input;
        Object value;
        assert (arguments.size() == 3) : "Invalid number of arguments";
        Symbol symbol = arguments.get(0);
        if (symbol instanceof Input && (value = (input = (Input)symbol).value()) != null) {
            Period p = (Period)value;
            DateBinFunction.checkMonthsAndYears(p);
            long intervalInMs = p.toStandardDuration().getMillis();
            if (intervalInMs == 0L) {
                throw new IllegalArgumentException("Interval cannot be zero");
            }
            return new CompiledDateBin(this.signature, this.boundSignature, intervalInMs);
        }
        return this;
    }

    @Override
    @SafeVarargs
    public final Long evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object> ... args) {
        assert (args.length == 3) : "Invalid number of arguments";
        Object interval = args[0].value();
        Object timestamp = args[1].value();
        Object origin = args[2].value();
        if (interval == null || timestamp == null || origin == null) {
            return null;
        }
        Period p = (Period)interval;
        DateBinFunction.checkMonthsAndYears(p);
        return DateBinFunction.getBinnedTimestamp(p.toStandardDuration().getMillis(), (Long)timestamp, (Long)origin);
    }

    private static void checkMonthsAndYears(Period p) {
        if (p.getMonths() != 0 || p.getYears() != 0) {
            throw new IllegalArgumentException("Cannot use intervals containing months or years");
        }
    }

    private static long getBinnedTimestamp(long interval, long timestamp, long origin) {
        if (interval == 0L) {
            throw new IllegalArgumentException("Interval cannot be zero");
        }
        long diff = timestamp - origin;
        if (diff >= 0L) {
            return timestamp - diff % interval;
        }
        if (interval > 0L) {
            return timestamp - diff % interval - interval;
        }
        return timestamp - diff % interval + interval;
    }

    private static class CompiledDateBin
    extends Scalar<Long, Object> {
        private final long intervalInMs;

        private CompiledDateBin(Signature signature, BoundSignature boundSignature, long intervalInMs) {
            super(signature, boundSignature);
            this.intervalInMs = intervalInMs;
        }

        @Override
        @SafeVarargs
        public final Long evaluate(TransactionContext txnCtx, NodeContext nodeContext, Input<Object> ... args) {
            Object timestamp = args[1].value();
            Object origin = args[2].value();
            if (timestamp == null || origin == null) {
                return null;
            }
            return DateBinFunction.getBinnedTimestamp(this.intervalInMs, (Long)timestamp, (Long)origin);
        }
    }
}

