/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.common.collections.MapBuilder;
import io.crate.data.Input;
import io.crate.expression.scalar.TimeZoneParser;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.role.Roles;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.LongType;
import io.crate.types.TypeSignature;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.rounding.DateTimeUnit;
import org.elasticsearch.common.rounding.Rounding;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTimeZone;

public class DateTruncFunction
extends Scalar<Long, Object> {
    public static final String NAME = "date_trunc";
    private static final Map<String, DateTimeUnit> DATE_FIELD_PARSERS = MapBuilder.newMapBuilder().put((Object)"year", (Object)DateTimeUnit.YEAR_OF_CENTURY).put((Object)"quarter", (Object)DateTimeUnit.QUARTER).put((Object)"month", (Object)DateTimeUnit.MONTH_OF_YEAR).put((Object)"week", (Object)DateTimeUnit.WEEK_OF_WEEKYEAR).put((Object)"day", (Object)DateTimeUnit.DAY_OF_MONTH).put((Object)"hour", (Object)DateTimeUnit.HOUR_OF_DAY).put((Object)"minute", (Object)DateTimeUnit.MINUTES_OF_HOUR).put((Object)"second", (Object)DateTimeUnit.SECOND_OF_MINUTE).immutableMap();
    @Nullable
    private final Rounding tzRounding;

    public static void register(Functions.Builder module) {
        List<LongType> supportedTimestampTypes = List.of(DataTypes.TIMESTAMP, DataTypes.TIMESTAMPZ, DataTypes.LONG);
        TypeSignature stringType = DataTypes.STRING.getTypeSignature();
        for (DataType dataType : supportedTimestampTypes) {
            module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(stringType, dataType.getTypeSignature()).returnType(DataTypes.TIMESTAMPZ.getTypeSignature()).features(Scalar.DETERMINISTIC_AND_COMPARISON_REPLACEMENT).build(), DateTruncFunction::new);
            module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(stringType, stringType, dataType.getTypeSignature()).returnType(DataTypes.TIMESTAMPZ.getTypeSignature()).features(Scalar.DETERMINISTIC_AND_COMPARISON_REPLACEMENT).build(), DateTruncFunction::new);
        }
    }

    DateTruncFunction(Signature signature, BoundSignature boundSignature) {
        this(signature, boundSignature, null);
    }

    private DateTruncFunction(Signature signature, BoundSignature boundSignature, @Nullable Rounding tzRounding) {
        super(signature, boundSignature);
        this.tzRounding = tzRounding;
    }

    @Override
    public Scalar<Long, Object> compile(List<Symbol> arguments, String currentUser, Roles roles) {
        assert (arguments.size() > 1 && arguments.size() < 4) : "Invalid number of arguments";
        if (!arguments.get(0).symbolType().isValueSymbol()) {
            return this;
        }
        String interval = (String)((Input)arguments.get(0)).value();
        if (interval == null) {
            return this;
        }
        String timeZone = TimeZoneParser.DEFAULT_TZ_LITERAL.value();
        if (arguments.size() == 3) {
            timeZone = (String)((Input)arguments.get(1)).value();
        }
        return new DateTruncFunction(this.signature, this.boundSignature, this.rounding(interval, timeZone));
    }

    @Override
    public Symbol normalizeSymbol(Function symbol, TransactionContext txnCtx, NodeContext nodeCtx) {
        Literal tsSymbol;
        Literal timezone;
        assert (symbol.arguments().size() > 1 && symbol.arguments().size() < 4) : "Invalid number of arguments";
        if (DateTruncFunction.anyNonLiterals(symbol.arguments())) {
            return symbol;
        }
        Literal interval = (Literal)symbol.arguments().get(0);
        if (symbol.arguments().size() == 2) {
            timezone = TimeZoneParser.DEFAULT_TZ_LITERAL;
            tsSymbol = (Literal)symbol.arguments().get(1);
        } else {
            timezone = (Literal)symbol.arguments().get(1);
            tsSymbol = (Literal)symbol.arguments().get(2);
        }
        return Literal.of(DataTypes.TIMESTAMPZ, this.evaluate(txnCtx, nodeCtx, new Input[]{interval, timezone, tsSymbol}));
    }

    @Override
    public final Long evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input[] args) {
        Object value;
        assert (args.length > 1 && args.length < 4) : "Invalid number of arguments";
        String timeZone = TimeZoneParser.DEFAULT_TZ_LITERAL.value();
        if (args.length == 2) {
            value = args[1].value();
        } else {
            timeZone = (String)args[1].value();
            value = args[2].value();
        }
        if (value == null) {
            return null;
        }
        if (this.tzRounding == null) {
            String interval = (String)args[0].value();
            if (interval == null) {
                return null;
            }
            return this.truncate(this.rounding(interval, timeZone), DataTypes.TIMESTAMPZ.sanitizeValue(value));
        }
        return this.truncate(this.tzRounding, DataTypes.TIMESTAMPZ.sanitizeValue(value));
    }

    private Rounding rounding(String interval, String timeZoneString) {
        DateTimeUnit intervalAsUnit = DateTruncFunction.intervalAsUnit(interval);
        DateTimeZone timeZone = TimeZoneParser.parseTimeZone(timeZoneString);
        return Rounding.builder(intervalAsUnit).timeZone(timeZone).build();
    }

    private Long truncate(Rounding rounding, Long ts) {
        if (ts == null) {
            return null;
        }
        return rounding.round(ts);
    }

    private static DateTimeUnit intervalAsUnit(String interval) {
        if (interval == null) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "invalid interval NULL for scalar '%s'", NAME));
        }
        DateTimeUnit intervalAsUnit = DATE_FIELD_PARSERS.get(interval.toLowerCase(Locale.ENGLISH));
        if (intervalAsUnit == null) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "invalid interval '%s' for scalar '%s'", interval, NAME));
        }
        return intervalAsUnit;
    }
}

