/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.exceptions.MissingPrivilegeException;
import io.crate.exceptions.RoleUnknownException;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.Schemas;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.role.Permission;
import io.crate.role.Role;
import io.crate.role.Roles;
import io.crate.role.Securable;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import org.jetbrains.annotations.Nullable;

public class HasPrivilegeFunction
extends Scalar<Boolean, Object> {
    private final ParsePermissions parsePermissions;
    private final BiFunction<Roles, Object, Role> getUser;
    private final CheckPrivilege checkPrivilege;

    public static Role userByName(Roles roles, Object userName) {
        return roles.getUser((String)userName);
    }

    public static Role userByOid(Roles roles, Object userOid) {
        int oid = (Integer)userOid;
        Role user = roles.findUser(oid);
        if (user == null) {
            throw new RoleUnknownException(oid);
        }
        return user;
    }

    public HasPrivilegeFunction(Signature signature, BoundSignature boundSignature, BiFunction<Roles, Object, Role> getUser, CheckPrivilege checkPrivilege, ParsePermissions parsePermissions) {
        super(signature, boundSignature);
        assert (this.signature().hasFeature(Scalar.Feature.STRICTNULL)) : "HasPrivilegeFunctions are nullable";
        this.getUser = getUser;
        this.checkPrivilege = checkPrivilege;
        this.parsePermissions = parsePermissions;
    }

    @Override
    public Symbol normalizeSymbol(Function symbol, TransactionContext txnCtx, NodeContext nodeCtx) {
        return HasPrivilegeFunction.evaluateIfLiterals(this, txnCtx, nodeCtx, symbol);
    }

    @Override
    public Scalar<Boolean, Object> compile(List<Symbol> arguments, String currentUser, Roles roles) {
        Object userValue = null;
        Symbol permissions = null;
        if (arguments.size() == 2) {
            userValue = currentUser;
            permissions = arguments.get(1);
        }
        if (arguments.size() == 3) {
            Symbol symbol = arguments.get(0);
            if (symbol instanceof Input) {
                Input input = (Input)symbol;
                userValue = input.value();
            }
            permissions = arguments.get(2);
        }
        Collection<Permission> compiledPermissions = this.normalizePermissionIfLiteral(permissions);
        if (userValue == null) {
            return this;
        }
        Role sessionUser = HasPrivilegeFunction.userByName(roles, currentUser);
        Role user = this.getUser.apply(roles, userValue);
        HasPrivilegeFunction.validateCallPrivileges(roles, sessionUser, user);
        return new CompiledHasPrivilege(roles, this.signature, this.boundSignature, sessionUser, user, compiledPermissions);
    }

    @Nullable
    private Collection<Permission> normalizePermissionIfLiteral(Symbol symbol) {
        if (symbol instanceof Input) {
            Input input = (Input)symbol;
            Object value = input.value();
            if (value == null) {
                return null;
            }
            return this.parsePermissions.parse((String)value);
        }
        return null;
    }

    @Override
    public final Boolean evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object>[] args) {
        Role user;
        Object privileges;
        Object schemaNameOrOid;
        Roles roles = nodeCtx.roles();
        Role sessionUser = HasPrivilegeFunction.userByName(nodeCtx.roles(), txnCtx.sessionSettings().userName());
        if (args.length == 2) {
            schemaNameOrOid = args[0].value();
            privileges = args[1].value();
            user = sessionUser;
        } else {
            Object userNameOrOid = args[0].value();
            if (userNameOrOid == null) {
                return null;
            }
            user = this.getUser.apply(roles, userNameOrOid);
            HasPrivilegeFunction.validateCallPrivileges(roles, sessionUser, user);
            schemaNameOrOid = args[1].value();
            privileges = args[2].value();
        }
        if (schemaNameOrOid == null || privileges == null) {
            return null;
        }
        return this.checkPrivilege.check(roles, user, schemaNameOrOid, this.parsePermissions.parse((String)privileges), nodeCtx.schemas());
    }

    protected static void validateCallPrivileges(Roles roles, Role sessionUser, Role user) {
        if (!(user.name().equals(sessionUser.name()) || roles.hasPrivilege(sessionUser, Permission.DQL, Securable.TABLE, "sys.privileges") || roles.hasPrivilege(sessionUser, Permission.AL, Securable.CLUSTER, "crate"))) {
            throw new MissingPrivilegeException(sessionUser.name());
        }
    }

    public static interface CheckPrivilege {
        public Boolean check(Roles var1, Role var2, Object var3, Collection<Permission> var4, Schemas var5);
    }

    public static interface ParsePermissions {
        public Collection<Permission> parse(String var1);
    }

    private class CompiledHasPrivilege
    extends Scalar<Boolean, Object> {
        private final Roles roles;
        private final Role sessionUser;
        private final Role user;
        private final java.util.function.Function<Object, Collection<Permission>> getPermissions;

        private CompiledHasPrivilege(Roles roles, Signature signature, BoundSignature boundSignature, Role sessionUser, @Nullable Role user, Collection<Permission> compiledPermissions) {
            super(signature, boundSignature);
            this.roles = roles;
            this.sessionUser = sessionUser;
            this.user = user;
            this.getPermissions = compiledPermissions != null ? s -> compiledPermissions : s -> HasPrivilegeFunction.this.parsePermissions.parse((String)s);
        }

        @Override
        @SafeVarargs
        public final Boolean evaluate(TransactionContext txnCtx, NodeContext nodeContext, Input<Object> ... args) {
            Object privilege;
            Object schema;
            if (args.length == 2) {
                schema = args[0].value();
                privilege = args[1].value();
            } else {
                HasPrivilegeFunction.validateCallPrivileges(this.roles, this.sessionUser, this.user);
                schema = args[1].value();
                privilege = args[2].value();
            }
            if (schema == null || privilege == null) {
                return null;
            }
            return HasPrivilegeFunction.this.checkPrivilege.check(this.roles, this.user, schema, this.getPermissions.apply(privilege), nodeContext.schemas());
        }
    }
}

