/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.expression.predicate.IsNullPredicate;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Symbol;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.ObjectType;
import io.crate.types.TypeSignature;
import java.util.Collection;
import java.util.Map;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lucene.search.Queries;

public final class NullOrEmptyFunction
extends Scalar<Boolean, Object> {
    public static void register(Functions.Builder module) {
        module.add(Signature.builder("null_or_empty", FunctionType.SCALAR).argumentTypes(DataTypes.UNTYPED_OBJECT.getTypeSignature()).returnType(DataTypes.BOOLEAN.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.NOTNULL).build(), NullOrEmptyFunction::new);
        module.add(Signature.builder("null_or_empty", FunctionType.SCALAR).argumentTypes(TypeSignature.parse("array(E)")).returnType(DataTypes.BOOLEAN.getTypeSignature()).typeVariableConstraints(TypeVariableConstraint.typeVariableOfAnyType("E")).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.NOTNULL).build(), NullOrEmptyFunction::new);
    }

    private NullOrEmptyFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    @SafeVarargs
    public final Boolean evaluate(TransactionContext txnCtx, NodeContext nodeContext, Input<Object> ... args) {
        Object value = args[0].value();
        if (value instanceof Map) {
            Map map = (Map)value;
            return map.isEmpty();
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return collection.isEmpty();
        }
        return value == null;
    }

    @Override
    public Query toQuery(Function function, LuceneQueryBuilder.Context context) {
        assert (function.arguments().size() == 1) : "Function has a single argument";
        Symbol arg = function.arguments().get(0);
        if (!(arg instanceof Reference)) {
            return null;
        }
        Reference ref = (Reference)arg;
        DataType<?> valueType = ref.valueType();
        if (valueType instanceof ObjectType) {
            ObjectType objectType = (ObjectType)valueType;
            if (objectType.innerTypes().isEmpty()) {
                return null;
            }
            BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder().setMinimumNumberShouldMatch(1);
            for (Map.Entry<String, DataType<?>> entry : objectType.innerTypes().entrySet()) {
                String childColumn = entry.getKey();
                Reference childRef = context.getRef(ref.column().getChild(childColumn));
                if (childRef == null) {
                    return null;
                }
                Query refExistsQuery = IsNullPredicate.refExistsQuery(childRef, context);
                if (refExistsQuery == null) {
                    return null;
                }
                booleanQuery.add(refExistsQuery, BooleanClause.Occur.SHOULD);
            }
            return Queries.not((Query)booleanQuery.build());
        }
        if (valueType instanceof ArrayType && ref.hasDocValues()) {
            return Queries.not((Query)new FieldExistsQuery(ref.storageIdent()));
        }
        return null;
    }
}

