/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.expression.symbol.Literal;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.joda.time.DateTimeZone;

public class TimeZoneParser {
    public static final DateTimeZone DEFAULT_TZ = DateTimeZone.UTC;
    public static final Literal<String> DEFAULT_TZ_LITERAL = Literal.of("UTC");
    private static final ConcurrentMap<String, DateTimeZone> TIME_ZONE_MAP = new ConcurrentHashMap<String, DateTimeZone>();

    private TimeZoneParser() {
    }

    public static DateTimeZone parseTimeZone(String timezone) throws IllegalArgumentException {
        if (timezone == null) {
            throw new IllegalArgumentException("invalid time zone value NULL");
        }
        if (timezone.equals(DEFAULT_TZ_LITERAL.value())) {
            return DEFAULT_TZ;
        }
        DateTimeZone tz = (DateTimeZone)TIME_ZONE_MAP.get(timezone);
        if (tz == null) {
            try {
                int index = timezone.indexOf(58);
                if (index != -1) {
                    int beginIndex = timezone.charAt(0) == '+' ? 1 : 0;
                    tz = DateTimeZone.forOffsetHoursMinutes((int)Integer.parseInt(timezone.substring(beginIndex, index)), (int)Integer.parseInt(timezone.substring(index + 1)));
                } else {
                    tz = DateTimeZone.forID((String)timezone);
                }
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "invalid time zone value '%s'", timezone));
            }
            TIME_ZONE_MAP.putIfAbsent(timezone, tz);
        }
        return tz;
    }
}

