/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.arithmetic;

import io.crate.expression.scalar.UnaryScalar;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.math.BigDecimal;
import java.math.MathContext;

public final class AbsFunction {
    public static final String NAME = "abs";

    private AbsFunction() {
    }

    public static void register(Functions.Builder builder) {
        for (DataType<? extends Number> type : DataTypes.NUMERIC_PRIMITIVE_TYPES) {
            TypeSignature typeSignature = type.getTypeSignature();
            builder.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(typeSignature).returnType(typeSignature).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> {
                DataType<?> argType = boundSignature.argTypes().get(0);
                return new UnaryScalar<Object, Object>((Signature)signature, (BoundSignature)boundSignature, (DataType<Object>)argType, x -> argType.sanitizeValue(Math.abs(((Number)x).doubleValue())));
            });
        }
        builder.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.NUMERIC.getTypeSignature()).returnType(DataTypes.NUMERIC.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new UnaryScalar<BigDecimal, BigDecimal>((Signature)signature, (BoundSignature)boundSignature, DataTypes.NUMERIC, x -> x.abs(MathContext.DECIMAL128)));
    }
}

