/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.arithmetic;

import io.crate.data.Input;
import io.crate.metadata.FunctionName;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.TypeSignature;
import java.util.LinkedHashMap;
import java.util.List;

public class MapFunction
extends Scalar<Object, Object> {
    public static final String NAME = "_map";
    public static final Signature SIGNATURE = Signature.builder(new FunctionName(null, "_map"), FunctionType.SCALAR).typeVariableConstraints(List.of(TypeVariableConstraint.typeVariableOfAnyType("V"))).argumentTypes(TypeSignature.parse("text"), TypeSignature.parse("V")).returnType(TypeSignature.parse("object(text, V)")).variableArityGroup(List.of(TypeSignature.parse("text"), TypeSignature.parse("V"))).features(Scalar.Feature.DETERMINISTIC).build();

    public static void register(Functions.Builder module) {
        module.add(SIGNATURE, MapFunction::new);
    }

    private MapFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    @SafeVarargs
    public final Object evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object> ... args) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>(args.length / 2, 1.0f);
        for (int i = 0; i < args.length - 1; i += 2) {
            m.put((String)args[i].value(), args[i + 1].value());
        }
        return m;
    }
}

