/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.arithmetic;

import ch.obermuhlner.math.big.BigDecimalMath;
import io.crate.expression.scalar.BinaryScalar;
import io.crate.expression.scalar.DoubleScalar;
import io.crate.expression.scalar.UnaryScalar;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import io.crate.types.DoubleType;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.function.DoubleUnaryOperator;
import java.util.function.UnaryOperator;

public final class TrigonometricFunctions {
    private static final BigDecimal MINUS_ONE = BigDecimal.valueOf(-1L);

    private TrigonometricFunctions() {
    }

    public static void register(Functions.Builder builder) {
        TrigonometricFunctions.register(builder, "sin", Math::sin);
        TrigonometricFunctions.registerNumeric(builder, "sin", x -> BigDecimalMath.sin((BigDecimal)x, (MathContext)MathContext.DECIMAL128));
        TrigonometricFunctions.register(builder, "asin", x -> Math.asin(TrigonometricFunctions.checkRange(x)));
        TrigonometricFunctions.registerNumeric(builder, "asin", x -> BigDecimalMath.asin((BigDecimal)TrigonometricFunctions.checkRange(x), (MathContext)MathContext.DECIMAL128));
        TrigonometricFunctions.register(builder, "cos", Math::cos);
        TrigonometricFunctions.registerNumeric(builder, "cos", x -> BigDecimalMath.sin((BigDecimal)x, (MathContext)MathContext.DECIMAL128));
        TrigonometricFunctions.register(builder, "acos", x -> Math.acos(TrigonometricFunctions.checkRange(x)));
        TrigonometricFunctions.registerNumeric(builder, "acos", x -> BigDecimalMath.acos((BigDecimal)TrigonometricFunctions.checkRange(x), (MathContext)MathContext.DECIMAL128));
        TrigonometricFunctions.register(builder, "tan", Math::tan);
        TrigonometricFunctions.registerNumeric(builder, "tan", x -> BigDecimalMath.tan((BigDecimal)x, (MathContext)MathContext.DECIMAL128));
        TrigonometricFunctions.register(builder, "cot", x -> 1.0 / Math.tan(x));
        TrigonometricFunctions.registerNumeric(builder, "cot", x -> BigDecimalMath.cot((BigDecimal)x, (MathContext)MathContext.DECIMAL128));
        TrigonometricFunctions.register(builder, "atan", Math::atan);
        TrigonometricFunctions.registerNumeric(builder, "atan", x -> BigDecimalMath.atan((BigDecimal)x, (MathContext)MathContext.DECIMAL128));
        builder.add(Signature.builder("atan2", FunctionType.SCALAR).argumentTypes(DataTypes.DOUBLE.getTypeSignature(), DataTypes.DOUBLE.getTypeSignature()).returnType(DataTypes.DOUBLE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new BinaryScalar<Double>(Math::atan2, (Signature)signature, (BoundSignature)boundSignature, DoubleType.INSTANCE));
        builder.add(Signature.builder("atan2", FunctionType.SCALAR).argumentTypes(DataTypes.NUMERIC.getTypeSignature(), DataTypes.NUMERIC.getTypeSignature()).returnType(DataTypes.NUMERIC.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, ignoredBoundSignature) -> new BinaryScalar<BigDecimal>((y, x) -> BigDecimalMath.atan2((BigDecimal)y, (BigDecimal)x, (MathContext)MathContext.DECIMAL128), (Signature)signature, BoundSignature.sameAsUnbound(signature), DataTypes.NUMERIC));
    }

    private static void register(Functions.Builder builder, String name, DoubleUnaryOperator func) {
        builder.add(Signature.builder(name, FunctionType.SCALAR).argumentTypes(DataTypes.DOUBLE.getTypeSignature()).returnType(DataTypes.DOUBLE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new DoubleScalar((Signature)signature, (BoundSignature)boundSignature, func));
    }

    private static void registerNumeric(Functions.Builder builder, String name, UnaryOperator<BigDecimal> func) {
        builder.add(Signature.builder(name, FunctionType.SCALAR).argumentTypes(DataTypes.NUMERIC.getTypeSignature()).returnType(DataTypes.NUMERIC.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, ignoredBoundSignature) -> new UnaryScalar((Signature)signature, BoundSignature.sameAsUnbound(signature), DataTypes.NUMERIC, func));
    }

    private static double checkRange(double value) {
        if (value < -1.0 || value > 1.0) {
            throw new IllegalArgumentException("input value " + value + " is out of range. Values must be in range of [-1.0, 1.0]");
        }
        return value;
    }

    private static BigDecimal checkRange(BigDecimal value) {
        if (value.compareTo(BigDecimal.ONE) > 0 || value.compareTo(MINUS_ONE) < 0) {
            throw new IllegalArgumentException("input value " + String.valueOf(value) + " is out of range. Values must be in range of [-1.0, 1.0]");
        }
        return value;
    }
}

