/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.bitwise;

import io.crate.common.TriConsumer;
import io.crate.expression.scalar.BinaryScalar;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.sql.tree.BitString;
import io.crate.types.BitStringType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.Locale;
import java.util.function.BinaryOperator;

public class BitwiseFunctions {
    private static final TriConsumer<String, BitString, BitString> LENGTH_VALIDATOR = (op, bs1, bs2) -> {
        if (bs1.length() != bs2.length()) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot %s bit strings of different sizes", op));
        }
    };

    private static <T> void register(Functions.Builder module, String name, DataType<T> type, BinaryOperator<T> operator) {
        TypeSignature typeSignature = type.getTypeSignature();
        Signature scalar = Signature.builder(name.toLowerCase(Locale.ENGLISH), FunctionType.SCALAR).argumentTypes(typeSignature, typeSignature).returnType(typeSignature).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build();
        module.add(scalar, (signature, boundSignature) -> new BinaryScalar(operator, (Signature)signature, (BoundSignature)boundSignature, type));
    }

    public static void register(Functions.Builder module) {
        BitwiseFunctions.register(module, "AND", DataTypes.LONG, (a, b) -> a & b);
        BitwiseFunctions.register(module, "AND", DataTypes.INTEGER, (a, b) -> a & b);
        BitwiseFunctions.register(module, "AND", DataTypes.SHORT, (a, b) -> (short)(a & b));
        BitwiseFunctions.register(module, "AND", DataTypes.BYTE, (a, b) -> (byte)(a & b));
        BitwiseFunctions.register(module, "AND", BitStringType.INSTANCE_ONE, (a, b) -> {
            LENGTH_VALIDATOR.accept((Object)"AND", a, b);
            a.bitSet().and(b.bitSet());
            return a;
        });
        BitwiseFunctions.register(module, "OR", DataTypes.LONG, (a, b) -> a | b);
        BitwiseFunctions.register(module, "OR", DataTypes.INTEGER, (a, b) -> a | b);
        BitwiseFunctions.register(module, "OR", DataTypes.SHORT, (a, b) -> (short)(a | b));
        BitwiseFunctions.register(module, "OR", DataTypes.BYTE, (a, b) -> (byte)(a | b));
        BitwiseFunctions.register(module, "OR", BitStringType.INSTANCE_ONE, (a, b) -> {
            LENGTH_VALIDATOR.accept((Object)"OR", a, b);
            a.bitSet().or(b.bitSet());
            return a;
        });
        BitwiseFunctions.register(module, "XOR", DataTypes.LONG, (a, b) -> a ^ b);
        BitwiseFunctions.register(module, "XOR", DataTypes.INTEGER, (a, b) -> a ^ b);
        BitwiseFunctions.register(module, "XOR", DataTypes.SHORT, (a, b) -> (short)(a ^ b));
        BitwiseFunctions.register(module, "XOR", DataTypes.BYTE, (a, b) -> (byte)(a ^ b));
        BitwiseFunctions.register(module, "XOR", BitStringType.INSTANCE_ONE, (a, b) -> {
            LENGTH_VALIDATOR.accept((Object)"XOR", a, b);
            a.bitSet().xor(b.bitSet());
            return a;
        });
    }
}

