/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.formatting;

import io.crate.common.StringUtils;
import io.crate.common.collections.Lists;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.TextStyle;
import java.time.temporal.IsoFields;
import java.time.temporal.JulianFields;
import java.time.temporal.TemporalField;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.Strings;

public class DateTimeFormatter {
    private static final TokenNode ROOT_TOKEN_NODE = new TokenNode();
    private final List<Object> tokens;
    private static final TemporalField WEEK_OF_YEAR;

    public DateTimeFormatter(String pattern) {
        this.tokens = DateTimeFormatter.parse(pattern);
    }

    private static List<Object> parse(String pattern) {
        ArrayList<Object> tokens = new ArrayList<Object>();
        String pattern_to_consume = pattern;
        int idx = 0;
        TokenNode currentTokenNode = ROOT_TOKEN_NODE;
        while (idx <= pattern_to_consume.length() && pattern_to_consume.length() > 0) {
            TokenNode nextTokenNode = idx == pattern_to_consume.length() ? null : currentTokenNode.children.get(Character.valueOf(pattern_to_consume.charAt(idx)));
            if (nextTokenNode == null && idx > 0) {
                if (currentTokenNode.isTokenNode()) {
                    tokens.add((Object)currentTokenNode.token);
                } else {
                    int depth;
                    for (depth = idx; depth > 0; --depth) {
                        currentTokenNode = currentTokenNode.parent;
                        if (!currentTokenNode.isTokenNode()) continue;
                        tokens.add((Object)currentTokenNode.token);
                        break;
                    }
                    tokens.add(pattern_to_consume.substring(depth, idx));
                }
                pattern_to_consume = pattern_to_consume.substring(idx);
                currentTokenNode = ROOT_TOKEN_NODE;
                idx = 0;
                continue;
            }
            if (nextTokenNode == null) {
                tokens.add(pattern_to_consume.substring(0, idx + 1));
                pattern_to_consume = pattern_to_consume.substring(idx + 1);
                continue;
            }
            ++idx;
            currentTokenNode = nextTokenNode;
        }
        return tokens;
    }

    public String format(LocalDateTime datetime) {
        return Lists.joinOn((String)"", this.tokens, x -> {
            if (x instanceof Token) {
                return DateTimeFormatter.getElement((Token)((Object)((Object)x)), datetime);
            }
            return String.valueOf(x);
        });
    }

    private static String getElement(Token token, LocalDateTime datetime) {
        String element = switch (token.ordinal()) {
            case 0, 1 -> {
                if (datetime.getHour() >= 12) {
                    yield Strings.padStart(String.valueOf(datetime.getHour() - 12), 2, '0');
                }
                yield Strings.padStart(String.valueOf(datetime.getHour()), 2, '0');
            }
            case 2 -> Strings.padStart(String.valueOf(datetime.getHour()), 2, '0');
            case 3 -> Strings.padStart(String.valueOf(datetime.getMinute()), 2, '0');
            case 4 -> Strings.padStart(String.valueOf(datetime.getSecond()), 2, '0');
            case 5 -> Strings.padStart(String.valueOf(datetime.getNano() / 1000000), 3, '0');
            case 6 -> Strings.padStart(String.valueOf(datetime.getNano() / 1000), 6, '0');
            case 7 -> datetime.getNano() / 100000000;
            case 8 -> datetime.getNano() / 10000000;
            case 9 -> datetime.getNano() / 1000000;
            case 10 -> datetime.getNano() / 100000;
            case 11 -> datetime.getNano() / 10000;
            case 12 -> datetime.getNano() / 1000;
            case 13, 14 -> {
                Instant midnight = datetime.toLocalDate().atStartOfDay().toInstant(ZoneOffset.UTC);
                yield String.valueOf(Duration.between(midnight, datetime.toInstant(ZoneOffset.UTC)).getSeconds());
            }
            case 15, 17 -> {
                if (datetime.getHour() >= 12) {
                    yield "PM";
                }
                yield "AM";
            }
            case 16, 18 -> {
                if (datetime.getHour() >= 12) {
                    yield "pm";
                }
                yield "am";
            }
            case 19, 21 -> {
                if (datetime.getHour() >= 12) {
                    yield "P.M.";
                }
                yield "A.M.";
            }
            case 20, 22 -> {
                if (datetime.getHour() >= 12) {
                    yield "p.m.";
                }
                yield "a.m.";
            }
            case 23 -> {
                String s = String.valueOf(datetime.getYear());
                yield s.substring(0, 1) + "," + s.substring(1);
            }
            case 24, 25 -> Strings.padStart(String.valueOf(datetime.getYear()), 4, '0');
            case 26 -> {
                String s = Strings.padStart(String.valueOf(datetime.getYear()), 4, '0');
                yield s.substring(s.length() - 3);
            }
            case 27 -> {
                String s = Strings.padStart(String.valueOf(datetime.getYear()), 4, '0');
                yield s.substring(s.length() - 2);
            }
            case 28 -> {
                String s = Strings.padStart(String.valueOf(datetime.getYear()), 4, '0');
                yield s.substring(s.length() - 1);
            }
            case 29 -> String.valueOf(datetime.get(IsoFields.WEEK_BASED_YEAR));
            case 30 -> {
                String s = String.valueOf(datetime.get(IsoFields.WEEK_BASED_YEAR));
                yield s.substring(s.length() - 3);
            }
            case 31 -> {
                String s = String.valueOf(datetime.get(IsoFields.WEEK_BASED_YEAR));
                yield s.substring(s.length() - 2);
            }
            case 32 -> {
                String s = String.valueOf(datetime.get(IsoFields.WEEK_BASED_YEAR));
                yield s.substring(s.length() - 1);
            }
            case 33, 35 -> {
                if (datetime.getYear() >= 1) {
                    yield "AD";
                }
                yield "BC";
            }
            case 34, 36 -> {
                if (datetime.getYear() >= 1) {
                    yield "ad";
                }
                yield "bc";
            }
            case 37, 39 -> {
                if (datetime.getYear() >= 1) {
                    yield "A.D";
                }
                yield "B.C";
            }
            case 38, 40 -> {
                if (datetime.getYear() >= 1) {
                    yield "a.d";
                }
                yield "b.c";
            }
            case 41 -> StringUtils.padEnd((String)datetime.getMonth().getDisplayName(TextStyle.FULL, Locale.ENGLISH), (int)7, (char)' ').toUpperCase(Locale.ENGLISH);
            case 42 -> StringUtils.capitalize((String)StringUtils.padEnd((String)datetime.getMonth().getDisplayName(TextStyle.FULL, Locale.ENGLISH), (int)7, (char)' '));
            case 43 -> StringUtils.padEnd((String)datetime.getMonth().getDisplayName(TextStyle.FULL, Locale.ENGLISH), (int)7, (char)' ').toLowerCase(Locale.ENGLISH);
            case 44 -> datetime.getMonth().getDisplayName(TextStyle.SHORT, Locale.ENGLISH).toUpperCase(Locale.ENGLISH);
            case 45 -> StringUtils.capitalize((String)datetime.getMonth().getDisplayName(TextStyle.SHORT, Locale.ENGLISH));
            case 46 -> datetime.getMonth().getDisplayName(TextStyle.SHORT, Locale.ENGLISH).toLowerCase(Locale.ENGLISH);
            case 47 -> Strings.padStart(String.valueOf(datetime.getMonth().getValue()), 2, '0');
            case 48 -> StringUtils.padEnd((String)datetime.getDayOfWeek().getDisplayName(TextStyle.FULL, Locale.ENGLISH), (int)8, (char)' ').toUpperCase(Locale.ENGLISH);
            case 49 -> StringUtils.padEnd((String)StringUtils.capitalize((String)datetime.getDayOfWeek().getDisplayName(TextStyle.FULL, Locale.ENGLISH)), (int)8, (char)' ');
            case 50 -> StringUtils.padEnd((String)datetime.getDayOfWeek().getDisplayName(TextStyle.FULL, Locale.ENGLISH), (int)8, (char)' ').toLowerCase(Locale.ENGLISH);
            case 51 -> datetime.getDayOfWeek().getDisplayName(TextStyle.SHORT, Locale.ENGLISH).toUpperCase(Locale.ENGLISH);
            case 52 -> StringUtils.capitalize((String)datetime.getDayOfWeek().getDisplayName(TextStyle.SHORT, Locale.ENGLISH));
            case 53 -> datetime.getDayOfWeek().getDisplayName(TextStyle.SHORT, Locale.ENGLISH).toLowerCase(Locale.ENGLISH);
            case 54 -> Strings.padStart(String.valueOf(datetime.getDayOfYear()), 3, '0');
            case 55 -> Strings.padStart(String.valueOf((datetime.get(IsoFields.WEEK_OF_WEEK_BASED_YEAR) - 1) * 7 + datetime.getDayOfWeek().getValue()), 3, '0');
            case 56 -> Strings.padStart(String.valueOf(datetime.getDayOfMonth()), 2, '0');
            case 57 -> datetime.getDayOfWeek().getValue() % 7 + 1;
            case 58 -> datetime.getDayOfWeek().getValue();
            case 59 -> datetime.getDayOfMonth() / 7 + 1;
            case 60 -> Strings.padStart(String.valueOf(datetime.get(WEEK_OF_YEAR)), 2, '0');
            case 61 -> Strings.padStart(String.valueOf(datetime.get(IsoFields.WEEK_OF_WEEK_BASED_YEAR)), 2, '0');
            case 62 -> (datetime.getYear() - 1) / 100 + 1;
            case 63 -> datetime.getLong(JulianFields.JULIAN_DAY);
            case 64 -> (datetime.getMonthValue() + 2) / 3;
            case 65 -> StringUtils.padEnd((String)DateTimeFormatter.toRoman(datetime.getMonthValue()).toUpperCase(Locale.ENGLISH), (int)4, (char)' ');
            case 66 -> StringUtils.padEnd((String)DateTimeFormatter.toRoman(datetime.getMonthValue()).toLowerCase(Locale.ENGLISH), (int)4, (char)' ');
            case 67, 68, 69, 70, 71 -> "";
            default -> "";
        };
        return String.valueOf(element);
    }

    private static String toRoman(int number) {
        int[] romanN = new int[]{10, 9, 5, 4, 1};
        String[] romanS = new String[]{"X", "IX", "V", "IV", "I"};
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < romanN.length; ++i) {
            while (number >= romanN[i]) {
                sb.append(romanS[i]);
                number -= romanN[i];
            }
        }
        return sb.toString();
    }

    static {
        for (Token token : Token.values()) {
            ROOT_TOKEN_NODE.addChild(token);
        }
        WEEK_OF_YEAR = WeekFields.of(Locale.ENGLISH).weekOfWeekBasedYear();
    }

    static class TokenNode {
        private final Map<Character, TokenNode> children = new HashMap<Character, TokenNode>();
        private Token token;
        public final TokenNode parent;

        public TokenNode() {
            this.token = null;
            this.parent = null;
        }

        private TokenNode(String tokenString, Token token, TokenNode parent) {
            this.parent = parent;
            if (tokenString.length() == 1) {
                this.token = token;
            } else {
                this.token = null;
                this.addChild(tokenString.substring(1), token);
            }
        }

        public void addChild(Token token) {
            this.addChild(token.toString(), token);
        }

        private void addChild(String tokenString, Token token) {
            TokenNode child = this.children.get(Character.valueOf(tokenString.charAt(0)));
            if (child == null) {
                this.children.put(Character.valueOf(tokenString.charAt(0)), new TokenNode(tokenString, token, this));
            } else if (tokenString.length() == 1) {
                child.token = token;
            } else {
                child.addChild(tokenString.substring(1), token);
            }
        }

        public boolean isTokenNode() {
            return this.token != null;
        }

        public boolean isRootNode() {
            return this.parent == null;
        }
    }

    private static enum Token {
        HOUR_OF_DAY("HH"),
        HOUR_OF_DAY12("HH12"),
        HOUR_OF_DAY24("HH24"),
        MINUTE("MI"),
        SECOND("SS"),
        MILLISECOND("MS"),
        MICROSECOND("US"),
        TENTH_OF_SECOND("FF1"),
        HUNDREDTH_OF_SECOND("FF2"),
        MILLISECOND_FF("FF3"),
        TENTH_OF_MILLISECOND("FF4"),
        HUNDREDTH_OF_MILLISECOND("FF5"),
        MICROSECOND_FF("FF6"),
        SECONDS_PAST_MIDNIGHT("SSSS"),
        SECONDS_PAST_MIDNIGHT_S("SSSSS"),
        AM_UPPER("AM"),
        AM_LOWER("am"),
        PM_UPPER("PM"),
        PM_LOWER("pm"),
        A_M_UPPER("A.M."),
        A_M_LOWER("a.m."),
        P_M_UPPER("P.M."),
        P_M_LOWER("p.m."),
        YEAR_WITH_COMMA("Y,YYY"),
        YEAR_YYYY("YYYY"),
        YEAR_LOWER_YYYY("yyyy"),
        YEAR_YYY("YYY"),
        YEAR_YY("YY"),
        YEAR_Y("Y"),
        ISO_YEAR_YYY("IYYY"),
        ISO_YEAR_YY("IYY"),
        ISO_YEAR_Y("IY"),
        ISO_YEAR("I"),
        BC_ERA_UPPER("BC"),
        BC_ERA_LOWER("bc"),
        AD_ERA_UPPER("AD"),
        AD_ERA_LOWER("ad"),
        B_C_ERA_UPPER("B.C"),
        B_C_ERA_LOWER("b.c"),
        A_D_ERA_UPPER("A.D"),
        A_D_ERA_LOWER("a.d"),
        MONTH_UPPER("MONTH"),
        MONTH_CAPITALIZED("Month"),
        MONTH_LOWER("month"),
        ABBREVIATED_MONTH_UPPER("MON"),
        ABBREVIATED_MONTH_CAPITALIZED("Mon"),
        ABBREVIATED_MONTH_LOWER("mon"),
        MONTH_NUMBER("MM"),
        DAY_UPPER("DAY"),
        DAY_CAPITALIZED("Day"),
        DAY_LOWER("day"),
        ABBREVIATED_DAY_UPPER("DY"),
        ABBREVIATED_DAY_CAPITALIZED("Dy"),
        ABBREVIATED_DAY_LOWER("dy"),
        DAY_OF_YEAR("DDD"),
        DAY_OF_ISO_WEEK_NUMBERING_YEAR("IDDD"),
        DAY_OF_MONTH("DD"),
        DAY_OF_WEEK("D"),
        ISO_DAY_OF_WEEK("ID"),
        WEEK_OF_MONTH("W"),
        WEEK_NUMBER_OF_YEAR("WW"),
        WEEK_NUMBER_OF_ISO_YEAR("IW"),
        CENTURY("CC"),
        JULIAN_DAY("J"),
        QUARTER("Q"),
        ROMAN_MONTH_UPPER("RM"),
        ROMAN_MONTH_LOWER("rm"),
        TIMEZONE_UPPER("TZ"),
        TIMEZONE_LOWER("tz"),
        TIMEZONE_HOURS("TZH"),
        TIMEZONE_MINUTES("TZM"),
        TIMEZONE_OFFSET_FROM_UTC("OF");

        private final String token;

        private Token(String token) {
            this.token = token;
        }

        public String toString() {
            return this.token;
        }
    }
}

