/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.geo;

import io.crate.data.Input;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.lucene.search.Queries;
import org.locationtech.spatial4j.shape.Point;

public class DistanceFunction
extends Scalar<Double, Point> {
    public static final String NAME = "distance";

    public static void register(Functions.Builder module) {
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.GEO_POINT.getTypeSignature(), DataTypes.GEO_POINT.getTypeSignature()).returnType(DataTypes.DOUBLE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), DistanceFunction::new);
    }

    private DistanceFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    public Double evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Point>[] args) {
        assert (args.length == 2) : "number of args must be 2";
        return DistanceFunction.evaluate(args[0], args[1]);
    }

    public static Double evaluate(Input<Point> arg1, Input<Point> arg2) {
        Point value1 = (Point)arg1.value();
        if (value1 == null) {
            return null;
        }
        Point value2 = (Point)arg2.value();
        if (value2 == null) {
            return null;
        }
        return GeoUtils.arcDistance(value1.getY(), value1.getX(), value2.getY(), value2.getX());
    }

    @Override
    public Symbol normalizeSymbol(Function symbol, TransactionContext txnCtx, NodeContext nodeCtx) {
        Symbol arg1 = symbol.arguments().get(0);
        Symbol arg2 = symbol.arguments().get(1);
        boolean arg1IsReference = true;
        int numLiterals = 0;
        if (arg1.symbolType().isValueSymbol()) {
            numLiterals = (short)(numLiterals + 1);
            arg1IsReference = false;
        }
        if (arg2.symbolType().isValueSymbol()) {
            numLiterals = (short)(numLiterals + 1);
        }
        if (numLiterals == 2) {
            return Literal.of(DistanceFunction.evaluate((Input<Point>)((Input)arg1), (Input<Point>)((Input)arg2)));
        }
        if (!arg1IsReference) {
            return new Function(this.signature, Arrays.asList(arg2, arg1), this.signature.getReturnType().createType());
        }
        return symbol;
    }

    @Override
    public Query toQuery(Function parent, Function inner, LuceneQueryBuilder.Context context) {
        Reference pointRef;
        Symbol symbol;
        block6: {
            block5: {
                assert (inner.name().equals(NAME)) : "function must be distance";
                List<Symbol> innerArgs = inner.arguments();
                symbol = innerArgs.get(0);
                if (!(symbol instanceof Reference)) break block5;
                pointRef = (Reference)symbol;
                symbol = innerArgs.get(1);
                if (symbol instanceof Literal) break block6;
            }
            return null;
        }
        Literal pointLiteral = (Literal)symbol;
        List<Symbol> parentArgs = parent.arguments();
        Symbol symbol2 = parentArgs.get(1);
        if (!(symbol2 instanceof Literal)) {
            return null;
        }
        Literal parentRhs = (Literal)symbol2;
        Double distance = DataTypes.DOUBLE.implicitCast(parentRhs.value());
        String parentName = parent.name();
        Point pointValue = (Point)pointLiteral.value();
        String fieldName = pointRef.storageIdent();
        return DistanceFunction.esV5DistanceQuery(parent, context, parentName, fieldName, distance, pointValue);
    }

    private static Query esV5DistanceQuery(Function parentFunction, LuceneQueryBuilder.Context context, String parentOperatorName, String columnName, Double distance, Point lonLat) {
        switch (parentOperatorName) {
            case "op_<=": 
            case "op_<": {
                return LatLonPoint.newDistanceQuery((String)columnName, (double)lonLat.getY(), (double)lonLat.getX(), (double)distance);
            }
            case "op_>=": {
                if (distance - 1.0E-6 <= 0.0) {
                    return new MatchAllDocsQuery();
                }
            }
            case "op_>": {
                return Queries.not(LatLonPoint.newDistanceQuery((String)columnName, (double)lonLat.getY(), (double)lonLat.getX(), (double)distance));
            }
            case "op_=": {
                return DistanceFunction.eqDistance(parentFunction, context, columnName, distance, lonLat);
            }
        }
        return null;
    }

    private static Query eqDistance(Function parentFunction, LuceneQueryBuilder.Context context, String columnName, Double distance, Point lonLat) {
        double smallDistance = distance * 0.99;
        if (smallDistance <= 0.0) {
            return LatLonPoint.newDistanceQuery((String)columnName, (double)lonLat.getY(), (double)lonLat.getX(), (double)0.0);
        }
        Query withinSmallCircle = LatLonPoint.newDistanceQuery((String)columnName, (double)lonLat.getY(), (double)lonLat.getX(), (double)smallDistance);
        Query withinLargeCircle = LatLonPoint.newDistanceQuery((String)columnName, (double)lonLat.getY(), (double)lonLat.getX(), (double)(distance * 1.01));
        return new BooleanQuery.Builder().add(withinLargeCircle, BooleanClause.Occur.MUST).add(withinSmallCircle, BooleanClause.Occur.MUST_NOT).add(LuceneQueryBuilder.genericFunctionFilter(parentFunction, context), BooleanClause.Occur.FILTER).build();
    }
}

