/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.postgres;

import io.crate.data.Input;
import io.crate.metadata.FunctionName;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;

public class PgEncodingToCharFunction
extends Scalar<String, Integer> {
    private static final FunctionName FQN = new FunctionName("pg_catalog", "pg_encoding_to_char");

    public static void register(Functions.Builder module) {
        module.add(Signature.builder(FQN, FunctionType.SCALAR).argumentTypes(DataTypes.INTEGER.getTypeSignature()).returnType(DataTypes.STRING.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), PgEncodingToCharFunction::new);
    }

    public PgEncodingToCharFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    @SafeVarargs
    public final String evaluate(TransactionContext txnCtx, NodeContext nodeContext, Input<Integer> ... args) {
        Integer value = (Integer)args[0].value();
        if (value == null || value < 0 || value >= PgEncodingIdentifiers.values().length) {
            return null;
        }
        return PgEncodingIdentifiers.values()[value].name();
    }

    private static enum PgEncodingIdentifiers {
        SQL_ASCII,
        EUC_JP,
        EUC_CN,
        EUC_KR,
        EUC_TW,
        EUC_JIS_2004,
        UTF8,
        MULE_INTERNAL,
        LATIN1,
        LATIN2,
        LATIN3,
        LATIN4,
        LATIN5,
        LATIN6,
        LATIN7,
        LATIN8,
        LATIN9,
        LATIN10,
        WIN1256,
        WIN1258,
        WIN866,
        WIN874,
        KOI8R,
        WIN1251,
        WIN1252,
        ISO_8859_5,
        ISO_8859_6,
        ISO_8859_7,
        ISO_8859_8,
        WIN1250,
        WIN1253,
        WIN1254,
        WIN1255,
        WIN1257,
        KOI8U,
        SJIS,
        BIG5,
        GBK,
        UHC,
        GB18030,
        JOHAB,
        SHIFT_JIS_2004;

    }
}

