/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.systeminformation;

import io.crate.data.Input;
import io.crate.metadata.FunctionName;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class CurrentSchemasFunction
extends Scalar<List<String>, Boolean> {
    public static final String NAME = "current_schemas";
    private static final FunctionName FQN = new FunctionName("pg_catalog", "current_schemas");

    public static void register(Functions.Builder module) {
        module.add(Signature.builder(FQN, FunctionType.SCALAR).argumentTypes(DataTypes.BOOLEAN.getTypeSignature()).returnType(DataTypes.STRING_ARRAY.getTypeSignature()).features(EnumSet.of(Scalar.Feature.NOTNULL)).build(), CurrentSchemasFunction::new);
    }

    public CurrentSchemasFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    @SafeVarargs
    public final List<String> evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Boolean> ... args) {
        assert (args.length == 1) : "expecting 1 boolean argument";
        Boolean includeImplicitSchemas = (Boolean)args[0].value();
        if (includeImplicitSchemas == null) {
            includeImplicitSchemas = false;
        }
        ArrayList<String> schemas = new ArrayList<String>();
        for (String schema : txnCtx.sessionSettings().searchPath()) {
            if (!includeImplicitSchemas.booleanValue() && schema.equals("pg_catalog")) continue;
            schemas.add(schema);
        }
        return schemas;
    }
}

