/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.timestamp;

import io.crate.data.Input;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import io.crate.types.TimeTZ;
import io.crate.types.TypeSignature;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Locale;

public class CurrentTimeFunction
extends Scalar<TimeTZ, Integer> {
    public static final String NAME = "current_time";
    private static final int MICRO_PRECISION = 6;

    public static void register(Functions.Builder module) {
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.INTEGER.getTypeSignature()).returnType(DataTypes.TIMETZ.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.NOTNULL).build(), CurrentTimeFunction::new);
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(new TypeSignature[0]).returnType(DataTypes.TIMETZ.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.NOTNULL).build(), CurrentTimeFunction::new);
    }

    private CurrentTimeFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    @SafeVarargs
    public final TimeTZ evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Integer> ... args) {
        Integer precision = 6;
        if (args.length == 1) {
            precision = (Integer)args[0].value();
            if (precision == null) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "NULL precision not supported for %s", this.signature.getName().name()));
            }
            if (precision < 0 || precision > 6) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "precision must be between [0..%d]", 6));
            }
        }
        Instant currentInstant = txnCtx.currentInstant();
        long microsSinceMidnight = ChronoUnit.MICROS.between(currentInstant.truncatedTo(ChronoUnit.DAYS), currentInstant);
        long factor = (long)Math.pow(10.0, 6 - precision);
        return new TimeTZ(microsSinceMidnight / factor * factor, 0);
    }
}

