/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.symbol;

import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.Symbols;
import io.crate.expression.symbol.format.Style;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.Nullable;

public final class Aggregation
implements Symbol {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(Aggregation.class);
    private final Signature signature;
    private final DataType<?> boundSignatureReturnType;
    private final List<Symbol> inputs;
    private final DataType<?> valueType;
    private final Symbol filter;

    public Aggregation(Signature signature, DataType<?> valueType, List<Symbol> inputs) {
        this(signature, valueType, valueType, inputs, Literal.BOOLEAN_TRUE);
    }

    public Aggregation(Signature signature, DataType<?> boundSignatureReturnType, DataType<?> valueType, List<Symbol> inputs, Symbol filter) {
        Objects.requireNonNull(inputs, "inputs must not be null");
        Objects.requireNonNull(filter, "filter must not be null");
        this.valueType = valueType;
        this.signature = signature;
        this.boundSignatureReturnType = boundSignatureReturnType;
        this.inputs = inputs;
        this.filter = filter;
    }

    public Aggregation(StreamInput in) throws IOException {
        Signature generatedSignature = null;
        if (in.getVersion().before(Version.V_5_0_0)) {
            generatedSignature = Signature.readFromFunctionInfo(in);
        }
        this.valueType = DataTypes.fromStream(in);
        this.filter = in.getVersion().onOrAfter(Version.V_4_1_0) ? Symbol.fromStream(in) : Literal.BOOLEAN_TRUE;
        this.inputs = Symbols.fromStream(in);
        if (in.getVersion().onOrAfter(Version.V_4_2_0)) {
            if (in.getVersion().before(Version.V_5_0_0)) {
                in.readBoolean();
            }
            this.signature = new Signature(in);
            this.boundSignatureReturnType = DataTypes.fromStream(in);
        } else {
            assert (generatedSignature != null) : "expecting a non-null generated signature";
            this.signature = generatedSignature;
            this.boundSignatureReturnType = this.valueType;
        }
    }

    @Override
    public SymbolType symbolType() {
        return SymbolType.AGGREGATION;
    }

    @Override
    public <C, R> R accept(SymbolVisitor<C, R> visitor, C context) {
        return visitor.visitAggregation(this, context);
    }

    @Override
    public boolean any(Predicate<? super Symbol> predicate) {
        if (predicate.test(this)) {
            return true;
        }
        for (Symbol input : this.inputs) {
            if (!input.any(predicate)) continue;
            return true;
        }
        return this.filter.any(predicate);
    }

    @Override
    public DataType<?> valueType() {
        return this.valueType;
    }

    public DataType<?> boundSignatureReturnType() {
        return this.boundSignatureReturnType;
    }

    @Nullable
    public Signature signature() {
        return this.signature;
    }

    public List<Symbol> inputs() {
        return this.inputs;
    }

    public Symbol filter() {
        return this.filter;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().before(Version.V_5_0_0)) {
            this.signature.writeAsFunctionInfo(out, Symbols.typeView(this.inputs));
        }
        DataTypes.toStream(this.valueType, out);
        if (out.getVersion().onOrAfter(Version.V_4_1_0)) {
            Symbol.toStream(this.filter, out);
        }
        Symbols.toStream(this.inputs, out);
        if (out.getVersion().onOrAfter(Version.V_4_2_0)) {
            if (out.getVersion().before(Version.V_5_0_0)) {
                out.writeBoolean(true);
            }
            this.signature.writeTo(out);
            DataTypes.toStream(this.boundSignatureReturnType, out);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof Aggregation)) return false;
        Aggregation that = (Aggregation)o;
        if (!Objects.equals(this.signature, that.signature)) return false;
        if (!Objects.equals(this.inputs, that.inputs)) return false;
        if (!Objects.equals(this.valueType, that.valueType)) return false;
        if (!Objects.equals(this.filter, that.filter)) return false;
        return true;
    }

    public int hashCode() {
        int result = this.signature.hashCode();
        result = 31 * result + this.inputs.hashCode();
        result = 31 * result + this.valueType.hashCode();
        result = 31 * result + this.filter.hashCode();
        return result;
    }

    public String toString() {
        return this.toString(Style.UNQUALIFIED);
    }

    @Override
    public String toString(Style style) {
        StringBuilder sb = new StringBuilder(this.signature.getName().name()).append("(");
        for (int i = 0; i < this.inputs.size(); ++i) {
            sb.append(this.inputs.get(i).toString(style));
            if (i + 1 >= this.inputs.size()) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE + this.signature.ramBytesUsed() + this.boundSignatureReturnType.ramBytesUsed() + this.inputs.stream().mapToLong(Accountable::ramBytesUsed).sum() + this.valueType.ramBytesUsed() + this.filter.ramBytesUsed();
    }
}

