/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.symbol;

import io.crate.expression.symbol.FunctionCopyVisitor;
import io.crate.expression.symbol.MatchPredicate;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.Symbol;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public final class FieldReplacer
extends FunctionCopyVisitor<Function<? super ScopedSymbol, ? extends Symbol>> {
    private static final FieldReplacer REPLACER = new FieldReplacer();

    private FieldReplacer() {
    }

    public static Symbol replaceFields(Symbol tree, Function<? super ScopedSymbol, ? extends Symbol> replaceFunc) {
        if (tree == null) {
            return null;
        }
        return tree.accept(REPLACER, replaceFunc);
    }

    public static Function<? super Symbol, ? extends Symbol> bind(Function<? super ScopedSymbol, ? extends Symbol> replaceFunc) {
        return st -> FieldReplacer.replaceFields(st, replaceFunc);
    }

    @Override
    public Symbol visitField(ScopedSymbol field, Function<? super ScopedSymbol, ? extends Symbol> replaceFunc) {
        return replaceFunc.apply(field);
    }

    @Override
    public Symbol visitMatchPredicate(MatchPredicate matchPredicate, Function<? super ScopedSymbol, ? extends Symbol> mapper) {
        HashMap<Symbol, Symbol> newIdentBoost = new HashMap<Symbol, Symbol>();
        for (Map.Entry<Symbol, Symbol> entry : matchPredicate.identBoostMap().entrySet()) {
            Symbol key = entry.getKey();
            if (key instanceof ScopedSymbol) {
                ScopedSymbol scopedSymbol = (ScopedSymbol)key;
                Symbol newKey = mapper.apply(scopedSymbol);
                newIdentBoost.put(newKey, entry.getValue().accept(this, mapper));
                continue;
            }
            newIdentBoost.put(key, entry.getValue().accept(this, mapper));
        }
        return new MatchPredicate(newIdentBoost, matchPredicate.queryTerm().accept(this, mapper), matchPredicate.matchType(), matchPredicate.options().accept(this, mapper));
    }
}

