/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.symbol;

import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.expression.symbol.OuterColumn;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.format.Style;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import java.io.IOException;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamOutput;

public class SelectSymbol
implements Symbol {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(SelectSymbol.class);
    private final AnalyzedRelation relation;
    private final ArrayType<?> dataType;
    private final ResultType resultType;
    private final boolean isCorrelated;
    private final boolean parentIsOrderSensitive;

    public SelectSymbol(AnalyzedRelation relation, ArrayType<?> dataType, ResultType resultType, boolean parentIsOrderSensitive) {
        this.relation = relation;
        this.dataType = dataType;
        this.resultType = resultType;
        boolean[] isCorrelatedArr = new boolean[]{false};
        relation.visitSymbols(symbolTree -> {
            if (symbolTree.any(s -> s instanceof OuterColumn)) {
                isCorrelatedArr[0] = true;
            }
        });
        this.isCorrelated = isCorrelatedArr[0];
        this.parentIsOrderSensitive = parentIsOrderSensitive;
    }

    public AnalyzedRelation relation() {
        return this.relation;
    }

    public boolean isCorrelated() {
        return this.isCorrelated;
    }

    public boolean parentIsOrderSensitive() {
        return this.parentIsOrderSensitive;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("Cannot stream SelectSymbol");
    }

    @Override
    public SymbolType symbolType() {
        return SymbolType.SELECT_SYMBOL;
    }

    @Override
    public <C, R> R accept(SymbolVisitor<C, R> visitor, C context) {
        return visitor.visitSelectSymbol(this, context);
    }

    @Override
    public DataType<?> valueType() {
        if (this.resultType == ResultType.SINGLE_COLUMN_SINGLE_VALUE) {
            return this.dataType.innerType();
        }
        return this.dataType;
    }

    public DataType<?> innerType() {
        return this.dataType.innerType();
    }

    public String toString() {
        return "(" + String.valueOf(this.relation) + ")";
    }

    @Override
    public String toString(Style style) {
        return "(" + String.valueOf(this.relation) + ")";
    }

    public ResultType getResultType() {
        return this.resultType;
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE + this.dataType.ramBytesUsed();
    }

    public static enum ResultType {
        SINGLE_COLUMN_SINGLE_VALUE,
        SINGLE_COLUMN_MULTIPLE_VALUES,
        SINGLE_COLUMN_EXISTS;

    }
}

