/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.symbol;

import io.crate.exceptions.ConversionException;
import io.crate.expression.scalar.cast.CastMode;
import io.crate.expression.scalar.cast.ExplicitCastFunction;
import io.crate.expression.scalar.cast.ImplicitCastFunction;
import io.crate.expression.scalar.cast.TryCastFunction;
import io.crate.expression.symbol.AliasSymbol;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.format.Style;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Reference;
import io.crate.metadata.functions.Signature;
import io.crate.sql.tree.ColumnDefinition;
import io.crate.sql.tree.Expression;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.UndefinedType;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.jetbrains.annotations.Nullable;

public interface Symbol
extends Writeable,
Accountable {
    public static final Predicate<Symbol> IS_COLUMN;
    public static final Predicate<Symbol> IS_CORRELATED_SUBQUERY;

    public static boolean isLiteral(Symbol symbol, DataType<?> expectedType) {
        return symbol.symbolType() == SymbolType.LITERAL && symbol.valueType().equals(expectedType);
    }

    public static boolean hasLiteralValue(Symbol symbol, Object value) {
        Literal literal;
        while (symbol instanceof AliasSymbol) {
            AliasSymbol alias = (AliasSymbol)symbol;
            symbol = alias.symbol();
        }
        return symbol instanceof Literal && Objects.equals((literal = (Literal)symbol).value(), value);
    }

    @Nullable
    public static Symbol nullableFromStream(StreamInput in) throws IOException {
        return in.readBoolean() ? Symbol.fromStream(in) : null;
    }

    public static void nullableToStream(@Nullable Symbol symbol, StreamOutput out) throws IOException {
        if (symbol == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Symbol.toStream(symbol, out);
        }
    }

    public static void toStream(Symbol symbol, StreamOutput out) throws IOException {
        if (out.getVersion().before(Version.V_4_2_0) && symbol instanceof AliasSymbol) {
            AliasSymbol aliasSymbol = (AliasSymbol)symbol;
            Symbol.toStream(aliasSymbol.symbol(), out);
        } else {
            int ordinal = symbol.symbolType().ordinal();
            out.writeVInt(ordinal);
            symbol.writeTo(out);
        }
    }

    public static Symbol fromStream(StreamInput in) throws IOException {
        return SymbolType.VALUES.get(in.readVInt()).newInstance(in);
    }

    public SymbolType symbolType();

    public <C, R> R accept(SymbolVisitor<C, R> var1, C var2);

    public DataType<?> valueType();

    default public boolean isDeterministic() {
        return true;
    }

    default public boolean hasColumn(ColumnIdent column) {
        return this.any(s -> {
            ScopedSymbol field;
            Reference ref;
            return s instanceof Reference && (ref = (Reference)s).column().equals(column) || s instanceof ScopedSymbol && (field = (ScopedSymbol)s).column().equals(column);
        });
    }

    default public boolean hasFunctionType(FunctionType type) {
        return this.any(s -> {
            if (!(s instanceof Function)) return false;
            Function fn = (Function)s;
            if (!fn.signature.getType().equals((Object)type)) return false;
            return true;
        });
    }

    default public boolean any(Predicate<? super Symbol> predicate) {
        return predicate.test(this);
    }

    default public <T extends Symbol> void visit(Class<T> clazz, Consumer<? super T> consumer) {
        this.any(node -> {
            if (clazz.isInstance(node)) {
                consumer.accept((Object)clazz.cast(node));
            }
            return false;
        });
    }

    default public void visit(Predicate<? super Symbol> predicate, Consumer<? super Symbol> consumer) {
        this.any(node -> {
            if (predicate.test((Symbol)node)) {
                consumer.accept((Symbol)node);
            }
            return false;
        });
    }

    default public ColumnIdent toColumn() {
        return ColumnIdent.of(this.toString(Style.UNQUALIFIED));
    }

    default public ColumnDefinition<Expression> toColumnDefinition() {
        return new ColumnDefinition(this.toColumn().sqlFqn(), this.valueType().toColumnType(null), List.of());
    }

    default public Symbol cast(DataType<?> targetType, CastMode ... modes) {
        if (targetType.equals(UndefinedType.INSTANCE)) {
            return this;
        }
        if (targetType.equals(this.valueType())) {
            return this;
        }
        DataType<?> innerTargetType = ArrayType.unnest(targetType);
        DataType<?> innerValueType = ArrayType.unnest(this.valueType());
        if (innerTargetType.equals(DataTypes.UNTYPED_OBJECT) && innerTargetType.id() == innerValueType.id() && this.valueType().id() == targetType.id()) {
            return this;
        }
        if (innerTargetType.equals(DataTypes.NUMERIC) && this.valueType().id() == DataTypes.NUMERIC.id()) {
            return this;
        }
        return Symbol.generateCastFunction(this, targetType, modes);
    }

    default public Symbol uncast() {
        return this;
    }

    public String toString(Style var1);

    private static Symbol generateCastFunction(Symbol sourceSymbol, DataType<?> targetType, CastMode ... castModes) {
        Set<CastMode> modes = Set.of(castModes);
        if (!1.$assertionsDisabled && modes.containsAll(List.of(CastMode.EXPLICIT, CastMode.IMPLICIT))) {
            throw new AssertionError((Object)"explicit and implicit cast modes are mutually exclusive");
        }
        DataType<?> sourceType = sourceSymbol.valueType();
        if (!sourceType.isConvertableTo(targetType, modes.contains((Object)CastMode.EXPLICIT))) {
            throw new ConversionException(sourceType, targetType);
        }
        if (modes.contains((Object)CastMode.TRY) || modes.contains((Object)CastMode.EXPLICIT)) {
            Signature signature = modes.contains((Object)CastMode.TRY) ? TryCastFunction.SIGNATURE : ExplicitCastFunction.SIGNATURE;
            List<Symbol> arguments = List.of(sourceSymbol, Literal.of(targetType, null));
            return new Function(signature, arguments, targetType);
        }
        return new Function(ImplicitCastFunction.SIGNATURE, List.of(sourceSymbol, Literal.of(targetType.getTypeSignature().toString())), targetType);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        IS_COLUMN = s -> s instanceof ScopedSymbol || s instanceof Reference;
        IS_CORRELATED_SUBQUERY = s -> {
            SelectSymbol selectSymbol;
            return s instanceof SelectSymbol && (selectSymbol = (SelectSymbol)s).isCorrelated();
        };
    }
}

