/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.symbol;

import io.crate.Streamer;
import io.crate.analyze.OrderBy;
import io.crate.analyze.WindowDefinition;
import io.crate.common.collections.Lists;
import io.crate.expression.symbol.AliasSymbol;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.VoidReference;
import io.crate.expression.symbol.WindowFunction;
import io.crate.expression.symbol.format.Style;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.types.DataType;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.Nullable;

public final class Symbols {
    private Symbols() {
    }

    public static List<DataType<?>> typeView(List<? extends Symbol> symbols) {
        return Lists.mapLazy(symbols, Symbol::valueType);
    }

    public static Streamer<?>[] streamerArray(Symbol[] symbols) {
        Streamer[] streamers = new Streamer[symbols.length];
        for (int i = 0; i < symbols.length; ++i) {
            streamers[i] = symbols[i].valueType().streamer();
        }
        return streamers;
    }

    public static Streamer<?>[] streamerArray(Collection<? extends Symbol> symbols) {
        Streamer[] streamers = new Streamer[symbols.size()];
        Iterator<? extends Symbol> iter = symbols.iterator();
        for (int i = 0; i < symbols.size(); ++i) {
            streamers[i] = iter.next().valueType().streamer();
        }
        return streamers;
    }

    @Nullable
    public static <V> V lookupValueByColumn(Map<? extends Symbol, V> valuesBySymbol, ColumnIdent column) {
        for (Map.Entry<Symbol, V> entry : valuesBySymbol.entrySet()) {
            ScopedSymbol scopedSymbol;
            Reference ref;
            Symbol key = entry.getKey();
            if (key instanceof Reference && (ref = (Reference)key).column().equals(column)) {
                return entry.getValue();
            }
            if (!(key instanceof ScopedSymbol) || !(scopedSymbol = (ScopedSymbol)key).column().equals(column)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static boolean any(List<? extends Symbol> symbols, Predicate<? super Symbol> predicate) {
        for (int i = 0; i < symbols.size(); ++i) {
            Symbol symbol = symbols.get(i);
            if (!symbol.any(predicate)) continue;
            return true;
        }
        return false;
    }

    public static boolean any(Iterable<? extends Symbol> symbols, Predicate<? super Symbol> predicate) {
        for (Symbol symbol : symbols) {
            if (!symbol.any(predicate)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasColumn(Iterable<? extends Symbol> symbols, ColumnIdent path) {
        for (Symbol symbol : symbols) {
            if (!symbol.hasColumn(path)) continue;
            return true;
        }
        return false;
    }

    public static void toStream(Collection<? extends Symbol> symbols, StreamOutput out) throws IOException {
        out.writeVInt(symbols.size());
        for (Symbol symbol : symbols) {
            Symbol.toStream(symbol, out);
        }
    }

    public static List<Symbol> fromStream(StreamInput in) throws IOException {
        return in.readList(Symbol::fromStream);
    }

    public static String format(String messageTmpl, Symbol ... symbols) {
        Object[] formattedSymbols = new String[symbols.length];
        for (int i = 0; i < symbols.length; ++i) {
            Symbol s = symbols[i];
            formattedSymbols[i] = s == null ? "NULL" : s.toString(Style.UNQUALIFIED);
        }
        return String.format(Locale.ENGLISH, messageTmpl, formattedSymbols);
    }

    public static <T> void intersection(Symbol needle, Collection<T> haystack, Consumer<T> consumer) {
        needle.accept(new IntersectionVisitor<T>(haystack, consumer), null);
    }

    private static class IntersectionVisitor<T>
    extends SymbolVisitor<Void, Void> {
        private final Collection<T> haystack;
        private final Consumer<T> consumer;

        public IntersectionVisitor(Collection<T> haystack, Consumer<T> consumer) {
            this.haystack = haystack;
            this.consumer = consumer;
        }

        @Override
        public Void visitFunction(Function func, Void context) {
            if (this.haystack.contains(func)) {
                this.consumer.accept(func);
            } else {
                for (Symbol argument : func.arguments()) {
                    this.callConsumerOrVisit(argument);
                }
                Symbol filter = func.filter();
                if (filter != null) {
                    this.callConsumerOrVisit(filter);
                }
            }
            return null;
        }

        @Override
        public Void visitWindowFunction(WindowFunction windowFunc, Void context) {
            if (this.haystack.contains(windowFunc)) {
                this.consumer.accept(windowFunc);
            } else {
                Symbol endOffsetValue;
                Symbol symbol;
                for (Symbol argument : windowFunc.arguments()) {
                    this.callConsumerOrVisit(argument);
                }
                Symbol filter = windowFunc.filter();
                if (filter != null) {
                    this.callConsumerOrVisit(filter);
                }
                WindowDefinition windowDefinition = windowFunc.windowDefinition();
                for (Symbol symbol2 : windowDefinition.partitions()) {
                    this.callConsumerOrVisit(symbol2);
                }
                OrderBy orderBy = windowDefinition.orderBy();
                if (orderBy != null) {
                    for (Symbol orderBySymbol : orderBy.orderBySymbols()) {
                        this.callConsumerOrVisit(orderBySymbol);
                    }
                }
                if ((symbol = windowDefinition.windowFrameDefinition().start().value()) != null) {
                    this.callConsumerOrVisit(symbol);
                }
                if ((endOffsetValue = windowDefinition.windowFrameDefinition().end().value()) != null) {
                    this.callConsumerOrVisit(endOffsetValue);
                }
            }
            return null;
        }

        private void callConsumerOrVisit(Symbol symbol) {
            if (this.haystack.contains(symbol)) {
                this.consumer.accept(symbol);
            } else {
                symbol.accept(this, null);
            }
        }

        @Override
        public Void visitAlias(AliasSymbol aliasSymbol, Void context) {
            if (this.haystack.contains(aliasSymbol)) {
                this.consumer.accept(aliasSymbol);
            } else {
                aliasSymbol.symbol().accept(this, context);
            }
            return null;
        }

        @Override
        public Void visitField(ScopedSymbol field, Void context) {
            if (this.haystack.contains(field)) {
                this.consumer.accept(field);
            } else if (!field.column().isRoot()) {
                ColumnIdent root = field.column().getRoot();
                for (T t : this.haystack) {
                    ScopedSymbol scopedSymbol;
                    if (!(t instanceof ScopedSymbol) || !(scopedSymbol = (ScopedSymbol)t).column().equals(root)) continue;
                    this.consumer.accept(t);
                }
            }
            return null;
        }

        @Override
        public Void visitReference(Reference ref, Void context) {
            if (this.haystack.contains(ref)) {
                this.consumer.accept(ref);
            } else if (!ref.column().isRoot()) {
                ColumnIdent root = ref.column().getRoot();
                for (T t : this.haystack) {
                    ScopedSymbol tScopedSymbol;
                    Reference tRef;
                    if (t instanceof Reference && (tRef = (Reference)t).column().equals(root)) {
                        this.consumer.accept(t);
                        break;
                    }
                    if (!(ref instanceof VoidReference) || !(t instanceof ScopedSymbol) || !(tScopedSymbol = (ScopedSymbol)t).relation().equals(ref.ident().tableIdent()) || !tScopedSymbol.column().equals(root)) continue;
                    this.consumer.accept(t);
                    break;
                }
            }
            return null;
        }

        @Override
        protected Void visitSymbol(Symbol symbol, Void context) {
            if (this.haystack.contains(symbol)) {
                this.consumer.accept(symbol);
            }
            return null;
        }
    }
}

