/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.tablefunctions;

import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.expression.tablefunctions.ColumnOrientedRowsIterator;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.metadata.tablefunctions.TableFunctionImplementation;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.RowType;
import io.crate.types.TypeSignature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ValuesFunction {
    public static final String NAME = "_values";
    public static final Signature SIGNATURE = Signature.builder("_values", FunctionType.TABLE).argumentTypes(TypeSignature.parse("array(E)")).returnType(RowType.EMPTY.getTypeSignature()).typeVariableConstraints(TypeVariableConstraint.typeVariableOfAnyType("E")).features(Scalar.Feature.DETERMINISTIC).setVariableArity(true).build();

    public static void register(Functions.Builder builder) {
        builder.add(SIGNATURE, ValuesTableFunctionImplementation::of);
    }

    private static class ValuesTableFunctionImplementation
    extends TableFunctionImplementation<List<Object>> {
        private final RowType returnType;

        private static ValuesTableFunctionImplementation of(Signature signature, BoundSignature boundSignature) {
            List<DataType<?>> argTypes = boundSignature.argTypes();
            ArrayList fieldTypes = new ArrayList(argTypes.size());
            for (int i = 0; i < argTypes.size(); ++i) {
                DataType<?> dataType = argTypes.get(i);
                assert (dataType instanceof ArrayType) : "Arguments to _values must be of type array";
                fieldTypes.add(((ArrayType)dataType).innerType());
            }
            RowType returnType = new RowType(fieldTypes);
            return new ValuesTableFunctionImplementation(signature, argTypes, returnType);
        }

        private ValuesTableFunctionImplementation(Signature signature, List<DataType<?>> argTypes, RowType returnType) {
            super(signature, new BoundSignature(argTypes, returnType));
            this.returnType = returnType;
        }

        @Override
        @SafeVarargs
        public final Iterable<Row> evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<List<Object>> ... arguments) {
            return new ColumnOrientedRowsIterator(() -> this.iteratorsFrom(arguments));
        }

        private Iterator<Object>[] iteratorsFrom(Input<List<Object>>[] arguments) {
            Iterator[] iterators = new Iterator[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                List argument = (List)arguments[i].value();
                iterators[i] = argument == null ? Collections.emptyIterator() : argument.iterator();
            }
            return iterators;
        }

        @Override
        public RowType returnType() {
            return this.returnType;
        }

        @Override
        public boolean hasLazyResultSet() {
            return false;
        }
    }
}

