/*
 * Decompiled with CFR 0.152.
 */
package io.crate.lucene;

import io.crate.data.Input;
import io.crate.exceptions.UnsupportedFeatureException;
import io.crate.execution.engine.collect.DocInputFactory;
import io.crate.expression.InputFactory;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.eval.NullEliminator;
import io.crate.expression.reference.doc.lucene.CollectorContext;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import io.crate.expression.reference.doc.lucene.LuceneReferenceResolver;
import io.crate.expression.reference.doc.lucene.StoredRowLookup;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.Symbols;
import io.crate.expression.symbol.format.Style;
import io.crate.lucene.FunctionToQuery;
import io.crate.lucene.GenericFunctionQuery;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.DocReferences;
import io.crate.metadata.FunctionImplementation;
import io.crate.metadata.IndexType;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.doc.SysColumns;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.EqQuery;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCache;
import org.elasticsearch.Version;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.jetbrains.annotations.Nullable;

@Singleton
public class LuceneQueryBuilder {
    public static final Setting<Integer> INDICES_MAX_CLAUSE_COUNT_SETTING = Setting.intSetting("indices.query.bool.max_clause_count", 8192, 1, Integer.MAX_VALUE, Setting.Property.NodeScope);
    private static final Logger LOGGER = LogManager.getLogger(LuceneQueryBuilder.class);
    private static final Visitor VISITOR = new Visitor();
    private final NodeContext nodeCtx;

    @Inject
    public LuceneQueryBuilder(NodeContext nodeCtx) {
        this.nodeCtx = nodeCtx;
    }

    public Context convert(Symbol query, TransactionContext txnCtx, String indexName, IndexAnalyzers indexAnalyzers, DocTableInfo table, Version shardCreatedVersion, QueryCache queryCache) throws UnsupportedFeatureException {
        LuceneReferenceResolver refResolver = new LuceneReferenceResolver(indexName, table.partitionedByColumns(), table.isParentReferenceIgnored());
        EvaluatingNormalizer normalizer = new EvaluatingNormalizer(this.nodeCtx, RowGranularity.PARTITION, refResolver, null);
        Context ctx = new Context(table, shardCreatedVersion, txnCtx, this.nodeCtx, queryCache, indexAnalyzers, indexName, table.partitionedByColumns(), query);
        ctx.query = NullEliminator.eliminateNullsIfPossible(DocReferences.inverseSourceLookup(normalizer.normalize(query, txnCtx)), s -> normalizer.normalize((Symbol)s, txnCtx)).accept(VISITOR, ctx);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("WHERE CLAUSE [{}] -> LUCENE QUERY [{}] ", (Object)query.toString(Style.UNQUALIFIED), (Object)ctx.query);
        }
        return ctx;
    }

    public static Query genericFunctionFilter(Function function, Context context) {
        if (function.valueType() != DataTypes.BOOLEAN) {
            LuceneQueryBuilder.raiseUnsupported(function);
        }
        function = (Function)DocReferences.toDocLookup(function, r -> context.tableInfo().isIgnoredOrImmediateChildOfIgnored((Reference)r) || r.valueType() == DataTypes.GEO_POINT);
        InputFactory.Context<LuceneCollectorExpression<?>> ctx = context.docInputFactory.getCtx(context.txnCtx);
        Input<?> condition = ctx.add(function);
        List<LuceneCollectorExpression<?>> expressions = ctx.expressions();
        CollectorContext collectorContext = new CollectorContext(() -> StoredRowLookup.create(context.shardCreatedVersion, context.table, context.indexName));
        for (LuceneCollectorExpression luceneCollectorExpression : expressions) {
            luceneCollectorExpression.startCollect(collectorContext);
        }
        return new GenericFunctionQuery(function, expressions, condition);
    }

    private static void raiseUnsupported(Function function) {
        throw new UnsupportedOperationException(Symbols.format("Cannot convert function %s into a query", function));
    }

    public static class Context {
        Query query;
        final Map<String, Object> filteredFieldValues = new HashMap<String, Object>();
        private final DocTableInfo table;
        private final Version shardCreatedVersion;
        final DocInputFactory docInputFactory;
        final QueryCache queryCache;
        private final TransactionContext txnCtx;
        private final IndexAnalyzers indexAnalyzers;
        private final String indexName;
        final NodeContext nodeContext;
        private final Symbol parentQuery;
        static final Set<String> FILTERED_FIELDS = Set.of("_score");
        static final Map<String, String> UNSUPPORTED_FIELDS = Map.of("_version", "\"_version\" column can only be used in the WHERE clause with equals comparisons and if there are also equals comparisons on primary key columns", "_seq_no", "\"_seq_no\" and \"_primary_term\" columns can only be used together in the WHERE clause with equals comparisons and if there are also equals comparisons on primary key columns", "_primary_term", "\"_seq_no\" and \"_primary_term\" columns can only be used together in the WHERE clause with equals comparisons and if there are also equals comparisons on primary key columns");

        Context(DocTableInfo table, Version shardCreatedVersion, TransactionContext txnCtx, NodeContext nodeCtx, QueryCache queryCache, IndexAnalyzers indexAnalyzers, String indexName, List<Reference> partitionColumns, Symbol parentQuery) {
            this.table = table;
            this.shardCreatedVersion = shardCreatedVersion;
            this.nodeContext = nodeCtx;
            this.txnCtx = txnCtx;
            this.indexAnalyzers = indexAnalyzers;
            this.docInputFactory = new DocInputFactory(nodeCtx, new LuceneReferenceResolver(indexName, partitionColumns, table.isParentReferenceIgnored()));
            this.queryCache = queryCache;
            this.parentQuery = parentQuery;
            this.indexName = indexName;
        }

        public Query query() {
            return this.query;
        }

        @Nullable
        public Float minScore() {
            Object score = this.filteredFieldValues.get("_score");
            if (score == null) {
                return null;
            }
            return Float.valueOf(((Number)score).floatValue());
        }

        @Nullable
        public String unsupportedMessage(String field) {
            return UNSUPPORTED_FIELDS.get(field);
        }

        public NamedAnalyzer getAnalyzer(String analyzerName) {
            NamedAnalyzer namedAnalyzer = this.indexAnalyzers.get(analyzerName);
            if (namedAnalyzer == null) {
                throw new IllegalArgumentException("No analyzer found for [" + analyzerName + "]");
            }
            return namedAnalyzer;
        }

        public SymbolVisitor<Context, Query> visitor() {
            return VISITOR;
        }

        @Nullable
        public Reference getRef(String storageIdent) {
            return this.table.getReference(storageIdent);
        }

        @Nullable
        public Reference getRef(ColumnIdent column) {
            return this.table.getReadReference(column);
        }

        public DocTableInfo tableInfo() {
            return this.table;
        }

        public TransactionContext transactionContext() {
            return this.txnCtx;
        }

        public NodeContext nodeContext() {
            return this.nodeContext;
        }

        public Symbol parentQuery() {
            return this.parentQuery;
        }
    }

    static class Visitor
    extends SymbolVisitor<Context, Query> {
        Visitor() {
        }

        @Override
        public Query visitFunction(Function function, Context context) {
            assert (function != null) : "function must not be null";
            if (Visitor.fieldIgnored(function, context)) {
                return new MatchAllDocsQuery();
            }
            function = Visitor.rewriteAndValidateFields(function, context);
            FunctionImplementation implementation = context.nodeContext.functions().getQualified(function);
            if (implementation instanceof FunctionToQuery) {
                Query query;
                FunctionToQuery funcToQuery = (FunctionToQuery)((Object)implementation);
                try {
                    query = funcToQuery.toQuery(function, context);
                    if (query == null) {
                        query = this.queryFromInnerFunction(function, context);
                    }
                }
                catch (UnsupportedOperationException e) {
                    return LuceneQueryBuilder.genericFunctionFilter(function, context);
                }
                if (query != null) {
                    return query;
                }
            }
            return LuceneQueryBuilder.genericFunctionFilter(function, context);
        }

        private Query queryFromInnerFunction(Function parent, Context context) {
            for (Symbol arg : parent.arguments()) {
                Query query;
                Query query2;
                if (!(arg instanceof Function)) continue;
                Function inner = (Function)arg;
                FunctionImplementation implementation = context.nodeContext.functions().getQualified(inner);
                if (implementation instanceof FunctionToQuery) {
                    FunctionToQuery funcToQuery = (FunctionToQuery)((Object)implementation);
                    query2 = funcToQuery.toQuery(parent, inner, context);
                } else {
                    query2 = null;
                }
                if ((query = query2) == null) continue;
                return query;
            }
            return null;
        }

        private static boolean fieldIgnored(Function function, Context context) {
            if (function.arguments().size() != 2) {
                return false;
            }
            Symbol left = function.arguments().get(0);
            Symbol right = function.arguments().get(1);
            if (left.symbolType() == SymbolType.REFERENCE && right.symbolType().isValueSymbol()) {
                String columnName = ((Reference)left).column().name();
                if (Context.FILTERED_FIELDS.contains(columnName)) {
                    context.filteredFieldValues.put(columnName, ((Input)right).value());
                    return true;
                }
                String unsupportedMessage = Context.UNSUPPORTED_FIELDS.get(columnName);
                if (unsupportedMessage != null) {
                    throw new UnsupportedFeatureException(unsupportedMessage);
                }
            }
            return false;
        }

        private static Function rewriteAndValidateFields(Function function, Context context) {
            List<Symbol> arguments = function.arguments();
            if (arguments.size() == 2) {
                Symbol left = arguments.get(0);
                Symbol right = arguments.get(1);
                if (left.symbolType() == SymbolType.REFERENCE && right.symbolType().isValueSymbol()) {
                    Reference ref = (Reference)left;
                    if (ref.column().equals(SysColumns.UID)) {
                        return new Function(function.signature(), List.of(SysColumns.forTable(ref.ident().tableIdent(), SysColumns.ID.COLUMN), right), function.valueType());
                    }
                    String unsupportedMessage = context.unsupportedMessage(ref.column().name());
                    if (unsupportedMessage != null) {
                        throw new UnsupportedFeatureException(unsupportedMessage);
                    }
                }
            }
            return function;
        }

        @Override
        public Query visitReference(Reference ref, Context context) {
            EqQuery<Boolean> eqQuery;
            DataType<?> type = ref.valueType();
            if (type == DataTypes.BOOLEAN && (eqQuery = DataTypes.BOOLEAN.storageSupportSafe().eqQuery()) != null) {
                return eqQuery.termQuery(ref.storageIdent(), Boolean.TRUE, ref.hasDocValues(), ref.indexType() != IndexType.NONE);
            }
            return (Query)super.visitReference(ref, context);
        }

        @Override
        public Query visitLiteral(Literal<?> literal, Context context) {
            Object value = literal.value();
            if (value == null) {
                return new MatchNoDocsQuery("WHERE null -> no match");
            }
            try {
                return (Boolean)value != false ? new MatchAllDocsQuery() : new MatchNoDocsQuery("WHERE false -> no match");
            }
            catch (ClassCastException e) {
                return this.visitSymbol((Symbol)literal, context);
            }
        }

        @Override
        protected Query visitSymbol(Symbol symbol, Context context) {
            throw new UnsupportedOperationException(Symbols.format("Can't build query from symbol %s", symbol));
        }
    }
}

