/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.common.StringUtils;
import io.crate.common.collections.LexicographicalOrdering;
import io.crate.common.collections.Lists;
import io.crate.exceptions.InvalidColumnNameException;
import io.crate.sql.Identifiers;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.Literal;
import io.crate.sql.tree.QualifiedName;
import io.crate.sql.tree.QualifiedNameReference;
import io.crate.sql.tree.SubscriptExpression;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringJoiner;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract sealed class ColumnIdent
implements Comparable<ColumnIdent>,
Accountable,
Writeable {
    private static final Comparator<ColumnIdent> COMPARATOR = Comparator.comparing(ColumnIdent::name).thenComparing(ColumnIdent::path, new LexicographicalOrdering(Comparator.naturalOrder()));

    public static ColumnIdent of(StreamInput in) throws IOException {
        String name = in.readString();
        int numParts = in.readVInt();
        if (numParts == 0) {
            return new Col0(name);
        }
        ArrayList<String> path = new ArrayList<String>(numParts);
        for (int i = 0; i < numParts; ++i) {
            path.add(in.readString());
        }
        return new ColN(name, path);
    }

    public static ColumnIdent fromNameSafe(String name, List<String> path) {
        ColumnIdent columnIdent = path.isEmpty() ? new Col0(name) : new ColN(name, path);
        columnIdent.validForCreate();
        return columnIdent;
    }

    public static ColumnIdent fromNameSafe(QualifiedName qualifiedName, @Nullable List<String> path) {
        path = path == null ? List.of() : path;
        List parts = qualifiedName.getParts();
        if (parts.size() != 1) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Column reference \"%s\" has too many parts. A column must not have a schema or a table here.", qualifiedName));
        }
        String name = (String)parts.get(0);
        return ColumnIdent.fromNameSafe(name, path);
    }

    public static ColumnIdent of(String name) {
        return new Col0(name);
    }

    public static ColumnIdent of(String name, String child) {
        return new ColN(name, List.of(child));
    }

    public static ColumnIdent of(String name, @Nullable List<String> path) {
        return path == null || path.isEmpty() ? new Col0(name) : new ColN(name, path);
    }

    public static ColumnIdent getChildSafe(ColumnIdent parent, String name) {
        ColumnIdent.validateObjectKey(name);
        return parent.getChild(name);
    }

    public static ColumnIdent fromPath(@Nullable String path) {
        if (path == null) {
            return null;
        }
        List parts = StringUtils.splitToList((char)'.', (String)path);
        if (parts.size() > 1) {
            return new ColN((String)parts.get(0), parts.subList(1, parts.size()));
        }
        return new Col0((String)parts.get(0));
    }

    public abstract ColumnIdent getChild(String var1);

    public static Object get(Map<?, ?> map, ColumnIdent column) {
        Object obj = map.get(column.name());
        if (obj instanceof Map) {
            Map m = (Map)obj;
            Object element = null;
            for (int i = 0; i < column.path().size(); ++i) {
                Map innerMap;
                element = m.get(column.path().get(i));
                if (!(element instanceof Map)) {
                    return element;
                }
                m = innerMap = (Map)element;
            }
            return element;
        }
        return obj;
    }

    public Expression toExpression() {
        QualifiedNameReference fqn = new QualifiedNameReference(QualifiedName.of((String)this.name(), (String[])new String[0]));
        for (String child : this.path()) {
            fqn = new SubscriptExpression((Expression)fqn, (Expression)Literal.fromObject((Object)child));
        }
        return fqn;
    }

    public boolean isChildOf(ColumnIdent parent) {
        if (!this.name().equals(parent.name())) {
            return false;
        }
        if (this.path().size() > parent.path().size()) {
            Iterator<String> parentIt = parent.path().iterator();
            Iterator<String> it = this.path().iterator();
            while (parentIt.hasNext()) {
                if (parentIt.next().equals(it.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @NotNull
    public ColumnIdent replacePrefix(@NotNull ColumnIdent newName) {
        assert (newName.path().isEmpty() || this.isChildOf(newName.getParent()));
        ArrayList<String> replaced = new ArrayList<String>(newName.path());
        replaced.addAll(this.path().subList(newName.path().size(), this.path().size()));
        return replaced.isEmpty() ? new Col0(newName.name()) : new ColN(newName.name(), replaced);
    }

    private static void validateColumnName(String columnName) {
        ColumnIdent.validateObjectKey(columnName);
        if (ColumnIdent.isSystemColumn(columnName)) {
            throw new InvalidColumnNameException(columnName, "conflicts with system column pattern");
        }
    }

    private static void validateObjectKey(String columnName) {
        if (columnName.indexOf(46) != -1) {
            throw new InvalidColumnNameException(columnName, "contains a dot");
        }
        if (columnName.contains("[")) {
            throw new InvalidColumnNameException(columnName, "conflicts with subscript pattern, square brackets are not allowed");
        }
        for (int i = 0; i < columnName.length(); ++i) {
            switch (columnName.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': {
                    throw new InvalidColumnNameException(columnName, "contains illegal whitespace character");
                }
            }
        }
    }

    private static boolean isSystemColumn(String name) {
        int length = name.length();
        if (length == 0) {
            return false;
        }
        if (name.charAt(0) != '_') {
            return false;
        }
        for (int i = 1; i < length; ++i) {
            char ch = name.charAt(i);
            if (ch == '_' && (name.charAt(i - 1) == '_' || i + 1 == length)) {
                return false;
            }
            if (ch == '_' || ch >= 'a' && ch <= 'z') continue;
            return false;
        }
        return true;
    }

    @Nullable
    public ColumnIdent getParent() {
        switch (this.path().size()) {
            case 0: {
                return null;
            }
            case 1: {
                return new Col0(this.name());
            }
        }
        return new ColN(this.name(), this.path().subList(0, this.path().size() - 1));
    }

    @Nullable
    public ColumnIdent shiftRight() {
        switch (this.path().size()) {
            case 0: {
                return null;
            }
            case 1: {
                return new Col0(this.path().get(0));
            }
        }
        return new ColN(this.path().get(0), this.path().subList(1, this.path().size()));
    }

    public boolean isSystemColumn() {
        return ColumnIdent.isSystemColumn(this.name());
    }

    public abstract ColumnIdent getRoot();

    public abstract String name();

    public abstract List<String> path();

    public abstract boolean isRoot();

    public abstract String fqn();

    protected abstract String sqlFqn(String var1);

    public String quotedOutputName() {
        return this.sqlFqn(Identifiers.quoteIfNeeded((String)this.name()));
    }

    public String sqlFqn() {
        return this.sqlFqn(this.name());
    }

    public String toString() {
        return this.sqlFqn();
    }

    @Override
    public int compareTo(ColumnIdent o) {
        return COMPARATOR.compare(this, o);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name());
        out.writeVInt(this.path().size());
        for (String s : this.path()) {
            out.writeString(s);
        }
    }

    public ColumnIdent prepend(String name) {
        if (this.path().isEmpty()) {
            return new ColN(name, List.of(this.name()));
        }
        ArrayList<String> newPath = new ArrayList<String>(this.path());
        newPath.add(0, this.name());
        return new ColN(name, newPath);
    }

    public String leafName() {
        if (this.path().isEmpty()) {
            return this.name();
        }
        return this.path().getLast();
    }

    public Iterable<ColumnIdent> parents() {
        return () -> new Iterator<ColumnIdent>(){
            int level;
            {
                this.level = ColumnIdent.this.path().size();
            }

            @Override
            public boolean hasNext() {
                return this.level > 0;
            }

            @Override
            public ColumnIdent next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("ColumnIdent has no more parents");
                }
                --this.level;
                List<String> newPath = ColumnIdent.this.path().subList(0, this.level);
                return newPath.isEmpty() ? new Col0(ColumnIdent.this.name()) : new ColN(ColumnIdent.this.name(), newPath);
            }
        };
    }

    public void validForCreate() {
        ColumnIdent.validateColumnName(this.name());
        this.path().forEach(x -> ColumnIdent.validateObjectKey(x));
    }

    public List<String> getRelativePath(ColumnIdent parent) {
        assert (this.isChildOf(parent)) : parent.sqlFqn() + " is not parent of: " + this.sqlFqn();
        ArrayList<String> newPath = new ArrayList<String>();
        for (String p : this.path()) {
            if (parent.path().contains(p)) continue;
            newPath.add(p);
        }
        return newPath;
    }

    static final class Col0
    extends ColumnIdent {
        private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(Col0.class);
        private final String name;

        public Col0(String name) {
            this.name = name;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public List<String> path() {
            return List.of();
        }

        @Override
        public boolean isRoot() {
            return true;
        }

        @Override
        public ColumnIdent getRoot() {
            return this;
        }

        @Override
        public ColumnIdent getChild(String childName) {
            return new ColN(this.name, List.of(childName));
        }

        @Override
        protected String sqlFqn(String name) {
            return name;
        }

        @Override
        public String fqn() {
            return this.name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof Col0)) return false;
            Col0 other = (Col0)obj;
            if (!this.name.equals(other.name)) return false;
            return true;
        }

        public long ramBytesUsed() {
            return SHALLOW_SIZE + RamUsageEstimator.sizeOf((String)this.name);
        }
    }

    static final class ColN
    extends ColumnIdent {
        private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(ColN.class);
        private final String name;
        private final List<String> path;

        public ColN(String name, List<String> path) {
            assert (!path.isEmpty()) : "Must use ColumnIdent0 instances if path is empty";
            this.name = name;
            this.path = path;
        }

        @Override
        public ColumnIdent getChild(String childName) {
            return new ColN(this.name, Lists.concat(this.path, (Object)childName));
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public List<String> path() {
            return this.path;
        }

        @Override
        public boolean isRoot() {
            return false;
        }

        @Override
        public ColumnIdent getRoot() {
            return new Col0(this.name);
        }

        @Override
        protected String sqlFqn(String name) {
            StringBuilder sb = new StringBuilder(name);
            for (String s : this.path()) {
                sb.append("['");
                sb.append(s);
                sb.append("']");
            }
            return sb.toString();
        }

        @Override
        public String fqn() {
            StringJoiner stringJoiner = new StringJoiner(".");
            stringJoiner.add(this.name());
            for (String p : this.path()) {
                stringJoiner.add(p);
            }
            return stringJoiner.toString();
        }

        public int hashCode() {
            return 31 * this.name.hashCode() + 31 * this.path.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof ColN)) return false;
            ColN other = (ColN)obj;
            if (!this.name.equals(other.name)) return false;
            if (!this.path.equals(other.path)) return false;
            return true;
        }

        public long ramBytesUsed() {
            return SHALLOW_SIZE + RamUsageEstimator.sizeOf((String)this.name) + this.path.stream().mapToLong(RamUsageEstimator::sizeOf).sum();
        }
    }
}

