/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.sql.Identifiers;
import java.io.IOException;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.jetbrains.annotations.Nullable;

public record FunctionName(@Nullable String schema, String name) implements Writeable,
Accountable
{
    public FunctionName(String name) {
        this(null, name);
    }

    public FunctionName(StreamInput in) throws IOException {
        this(in.readOptionalString(), in.readString());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.schema);
        out.writeString(this.name);
    }

    public long ramBytesUsed() {
        return (this.schema == null ? 0L : RamUsageEstimator.sizeOf((String)this.schema)) + RamUsageEstimator.sizeOf((String)this.name);
    }

    @Override
    public String toString() {
        return "FunctionName{schema='" + this.schema + "', name='" + this.name + "'}";
    }

    public String displayName() {
        String functionName = this.isBuiltin() ? this.name : Identifiers.quoteIfNeeded((String)this.name);
        if (this.schema == null) {
            return functionName;
        }
        return Identifiers.quoteIfNeeded((String)this.schema) + "." + functionName;
    }

    public boolean isBuiltin() {
        return this.schema == null || "information_schema".equals(this.schema) || "pg_catalog".equals(this.schema);
    }
}

