/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.IndexType;
import io.crate.metadata.ReferenceIdent;
import io.crate.metadata.RowGranularity;
import io.crate.sql.tree.ColumnDefinition;
import io.crate.sql.tree.Expression;
import io.crate.types.DataType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.Nullable;

public interface Reference
extends Symbol {
    public static final Comparator<Reference> CMP_BY_POSITION_THEN_NAME = Comparator.comparing(Reference::position).thenComparing(r -> r.column().fqn());

    public static int indexOf(Iterable<? extends Reference> refs, ColumnIdent column) {
        int i = 0;
        for (Reference reference : refs) {
            if (reference.column().equals(column)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public ReferenceIdent ident();

    public ColumnIdent column();

    @Override
    default public ColumnIdent toColumn() {
        return this.column();
    }

    @Override
    default public ColumnDefinition<Expression> toColumnDefinition() {
        return new ColumnDefinition(this.toColumn().sqlFqn(), this.valueType().toColumnType(null), List.of());
    }

    public IndexType indexType();

    public boolean isNullable();

    public RowGranularity granularity();

    public int position();

    public long oid();

    public boolean isDropped();

    public boolean hasDocValues();

    @Nullable
    public Symbol defaultExpression();

    public boolean isGenerated();

    public Reference withReferenceIdent(ReferenceIdent var1);

    public Reference withOidAndPosition(LongSupplier var1, IntSupplier var2);

    public Reference withDropped(boolean var1);

    public Reference withValueType(DataType<?> var1);

    default public String storageIdent() {
        long oid = this.oid();
        if (oid == Metadata.COLUMN_OID_UNASSIGNED) {
            ColumnIdent column = this.column();
            if (!column.isRoot() && column.name().equals("_doc")) {
                column = column.shiftRight();
            }
            return column.fqn();
        }
        return Long.toString(oid);
    }

    default public String storageIdentLeafName() {
        return this.oid() == Metadata.COLUMN_OID_UNASSIGNED ? this.column().leafName() : Long.toString(this.oid());
    }

    public Map<String, Object> toMapping(int var1);

    public static void toStream(StreamOutput out, Reference ref) throws IOException {
        out.writeVInt(ref.symbolType().ordinal());
        ref.writeTo(out);
    }

    public static <T extends Reference> T fromStream(StreamInput in) throws IOException {
        return (T)((Reference)SymbolType.VALUES.get(in.readVInt()).newInstance(in));
    }

    public static HashMap<ColumnIdent, List<Reference>> buildTree(Iterable<Reference> references) {
        LinkedHashMap<ColumnIdent, List<Reference>> tree = new LinkedHashMap<ColumnIdent, List<Reference>>();
        for (Reference treeNode : references) {
            List siblings = tree.computeIfAbsent(treeNode.column().getParent(), k -> new ArrayList());
            siblings.add(treeNode);
        }
        return tree;
    }
}

