/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.Nullable;

public final class ReferenceIdent
implements Accountable {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(ReferenceIdent.class);
    private final RelationName relationName;
    private final ColumnIdent columnIdent;

    public ReferenceIdent(StreamInput in) throws IOException {
        this.columnIdent = ColumnIdent.of(in);
        this.relationName = new RelationName(in);
    }

    public ReferenceIdent(RelationName relationName, ColumnIdent columnIdent) {
        this.relationName = relationName;
        this.columnIdent = columnIdent;
    }

    public ReferenceIdent(RelationName relationName, String column) {
        this(relationName, ColumnIdent.of(column));
    }

    public ReferenceIdent(RelationName relationName, String column, @Nullable List<String> path) {
        this(relationName, ColumnIdent.of(column, path));
    }

    public RelationName tableIdent() {
        return this.relationName;
    }

    public ColumnIdent columnIdent() {
        return this.columnIdent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof ReferenceIdent)) return false;
        ReferenceIdent that = (ReferenceIdent)o;
        if (!Objects.equals(this.relationName, that.relationName)) return false;
        if (!Objects.equals(this.columnIdent, that.columnIdent)) return false;
        return true;
    }

    public int hashCode() {
        int result = this.relationName.hashCode();
        return 31 * result + this.columnIdent.hashCode();
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "<RefIdent: %s->%s>", this.relationName, this.columnIdent);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.columnIdent.writeTo(out);
        this.relationName.writeTo(out);
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE + this.relationName.ramBytesUsed() + this.columnIdent.ramBytesUsed();
    }
}

