/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.settings;

import io.crate.common.collections.Lists;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.cluster.routing.allocation.decider.FilterAllocationDecider;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public final class CrateSettings {
    public static final List<Setting<?>> EXPOSED_SETTINGS = Lists.concat(ClusterSettings.BUILT_IN_CLUSTER_SETTINGS.stream().filter(Setting::isExposed).toList(), List.of(Setting.simpleString(FilterAllocationDecider.CLUSTER_ROUTING_INCLUDE_GROUP_SETTING.getKey() + "_ip", Setting.Property.NodeScope, Setting.Property.Dynamic), Setting.simpleString(FilterAllocationDecider.CLUSTER_ROUTING_INCLUDE_GROUP_SETTING.getKey() + "_id", Setting.Property.NodeScope, Setting.Property.Dynamic), Setting.simpleString(FilterAllocationDecider.CLUSTER_ROUTING_INCLUDE_GROUP_SETTING.getKey() + "_host", Setting.Property.NodeScope, Setting.Property.Dynamic), Setting.simpleString(FilterAllocationDecider.CLUSTER_ROUTING_INCLUDE_GROUP_SETTING.getKey() + "_name", Setting.Property.NodeScope, Setting.Property.Dynamic), Setting.simpleString(FilterAllocationDecider.CLUSTER_ROUTING_EXCLUDE_GROUP_SETTING.getKey() + "_ip", Setting.Property.NodeScope, Setting.Property.Dynamic), Setting.simpleString(FilterAllocationDecider.CLUSTER_ROUTING_EXCLUDE_GROUP_SETTING.getKey() + "_id", Setting.Property.NodeScope, Setting.Property.Dynamic), Setting.simpleString(FilterAllocationDecider.CLUSTER_ROUTING_EXCLUDE_GROUP_SETTING.getKey() + "_host", Setting.Property.NodeScope, Setting.Property.Dynamic), Setting.simpleString(FilterAllocationDecider.CLUSTER_ROUTING_EXCLUDE_GROUP_SETTING.getKey() + "_name", Setting.Property.NodeScope, Setting.Property.Dynamic), Setting.simpleString(FilterAllocationDecider.CLUSTER_ROUTING_REQUIRE_GROUP_SETTING.getKey() + "_ip", Setting.Property.NodeScope, Setting.Property.Dynamic), Setting.simpleString(FilterAllocationDecider.CLUSTER_ROUTING_REQUIRE_GROUP_SETTING.getKey() + "_id", Setting.Property.NodeScope, Setting.Property.Dynamic), Setting.simpleString(FilterAllocationDecider.CLUSTER_ROUTING_REQUIRE_GROUP_SETTING.getKey() + "_host", Setting.Property.NodeScope, Setting.Property.Dynamic), Setting.simpleString(FilterAllocationDecider.CLUSTER_ROUTING_REQUIRE_GROUP_SETTING.getKey() + "_name", Setting.Property.NodeScope, Setting.Property.Dynamic)));
    private static final List<String> EXPOSED_SETTING_NAMES = EXPOSED_SETTINGS.stream().map(Setting::getKey).toList();

    public static boolean isValidSetting(String name) {
        return CrateSettings.isLoggingSetting(name) || CrateSettings.isArchivedSetting(name) || EXPOSED_SETTING_NAMES.contains(name) || !EXPOSED_SETTING_NAMES.stream().noneMatch(s -> s.startsWith(name + "."));
    }

    public static List<String> settingNamesByPrefix(String prefix) {
        if (CrateSettings.isLoggingSetting(prefix)) {
            return Collections.singletonList(prefix);
        }
        if (CrateSettings.isArchivedSetting(prefix)) {
            return Collections.singletonList(prefix);
        }
        ArrayList<String> filteredList = new ArrayList<String>();
        for (String key : EXPOSED_SETTING_NAMES) {
            if (!key.startsWith(prefix)) continue;
            filteredList.add(key);
        }
        return filteredList;
    }

    public static void checkIfRuntimeSetting(String name) {
        for (Setting<?> setting : EXPOSED_SETTINGS) {
            if (!setting.getKey().equals(name) || setting.isDynamic()) continue;
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Setting '%s' cannot be set/reset at runtime", name));
        }
    }

    public static void flattenSettings(Settings.Builder settingsBuilder, String key, Object value) {
        if (value instanceof Map) {
            for (Map.Entry setting : ((Map)value).entrySet()) {
                CrateSettings.flattenSettings(settingsBuilder, String.join((CharSequence)".", key, (CharSequence)setting.getKey()), setting.getValue());
            }
        } else {
            if (value == null) {
                throw new IllegalArgumentException("Cannot set \"" + key + "\" to `null`. Use `RESET [GLOBAL] \"" + key + "\"` to reset a setting to its default value");
            }
            if (value instanceof List) {
                Object values = DataTypes.STRING_ARRAY.sanitizeValue(value);
                settingsBuilder.put(key, String.join((CharSequence)",", (Iterable<? extends CharSequence>)values));
            } else {
                settingsBuilder.put(key, value.toString());
            }
        }
    }

    private static boolean isLoggingSetting(String name) {
        return name.startsWith("logger.");
    }

    private static boolean isArchivedSetting(String name) {
        return name.startsWith("archived.");
    }
}

