/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.sys;

import io.crate.execution.engine.collect.files.SummitsContext;
import io.crate.execution.engine.collect.files.SummitsIterable;
import io.crate.execution.engine.collect.stats.JobsLogs;
import io.crate.expression.reference.StaticTableDefinition;
import io.crate.expression.reference.sys.check.SysCheck;
import io.crate.expression.reference.sys.check.SysChecker;
import io.crate.expression.reference.sys.check.node.SysNodeCheck;
import io.crate.expression.reference.sys.check.node.SysNodeChecks;
import io.crate.expression.reference.sys.job.JobContext;
import io.crate.expression.reference.sys.job.JobContextLog;
import io.crate.expression.reference.sys.operation.OperationContext;
import io.crate.expression.reference.sys.operation.OperationContextLog;
import io.crate.expression.reference.sys.shard.ShardSegment;
import io.crate.expression.reference.sys.shard.ShardSegments;
import io.crate.expression.reference.sys.shard.SysAllocation;
import io.crate.expression.reference.sys.shard.SysAllocations;
import io.crate.expression.reference.sys.snapshot.SysSnapshot;
import io.crate.expression.reference.sys.snapshot.SysSnapshotRestoreInProgress;
import io.crate.expression.reference.sys.snapshot.SysSnapshots;
import io.crate.metadata.RelationName;
import io.crate.metadata.SystemTable;
import io.crate.metadata.sys.MetricsView;
import io.crate.metadata.sys.SysAllocationsTableInfo;
import io.crate.metadata.sys.SysChecksTableInfo;
import io.crate.metadata.sys.SysClusterTableInfo;
import io.crate.metadata.sys.SysHealth;
import io.crate.metadata.sys.SysJobsLogTableInfo;
import io.crate.metadata.sys.SysJobsTableInfo;
import io.crate.metadata.sys.SysMetricsTableInfo;
import io.crate.metadata.sys.SysNodeChecksTableInfo;
import io.crate.metadata.sys.SysOperationsLogTableInfo;
import io.crate.metadata.sys.SysOperationsTableInfo;
import io.crate.metadata.sys.SysRepositoriesTableInfo;
import io.crate.metadata.sys.SysSchemaInfo;
import io.crate.metadata.sys.SysSegmentsTableInfo;
import io.crate.metadata.sys.SysSessionsTableInfo;
import io.crate.metadata.sys.SysSnapshotRestoreTableInfo;
import io.crate.metadata.sys.SysSnapshotsTableInfo;
import io.crate.metadata.sys.SysSummitsTableInfo;
import io.crate.metadata.sys.TableHealth;
import io.crate.role.Permission;
import io.crate.role.Role;
import io.crate.role.Roles;
import io.crate.role.Securable;
import io.crate.role.metadata.SysPrivilegesTableInfo;
import io.crate.role.metadata.SysRolesTableInfo;
import io.crate.role.metadata.SysUsersTableInfo;
import io.crate.session.Session;
import io.crate.session.Sessions;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.elasticsearch.cluster.RestoreInProgress;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;

public class SysTableDefinitions {
    private final Map<RelationName, StaticTableDefinition<?>> tableDefinitions;

    @Inject
    public SysTableDefinitions(ClusterService clusterService, Roles roles, JobsLogs jobsLogs, SysSchemaInfo sysSchemaInfo, Set<SysCheck> sysChecks, SysNodeChecks sysNodeChecks, RepositoriesService repositoriesService, SysSnapshots sysSnapshots, SysAllocations sysAllocations, ShardSegments shardSegmentInfos, Sessions sessions) {
        Supplier<DiscoveryNode> localNode = clusterService::localNode;
        SystemTable sysClusterTableInfo = (SystemTable)sysSchemaInfo.getTableInfo(SysClusterTableInfo.IDENT.name());
        assert (sysClusterTableInfo != null) : "sys.cluster table must exist in sys schema";
        SystemTable<Role> userTable = SysUsersTableInfo.create(() -> clusterService.state().metadata().clusterUUID());
        SysChecker<SysCheck> sysChecker = new SysChecker<SysCheck>(sysChecks);
        SummitsIterable summits = new SummitsIterable();
        Map.Entry[] entryArray = new Map.Entry[19];
        entryArray[0] = Map.entry(SysUsersTableInfo.IDENT, new StaticTableDefinition<Role>(() -> CompletableFuture.completedFuture(roles.roles().stream().filter(Role::isUser).toList()), userTable.expressions(), false));
        entryArray[1] = Map.entry(SysRolesTableInfo.IDENT, new StaticTableDefinition<Role>(() -> CompletableFuture.completedFuture(roles.roles().stream().filter(r -> !r.isUser()).toList()), SysRolesTableInfo.INSTANCE.expressions(), false));
        entryArray[2] = Map.entry(SysPrivilegesTableInfo.IDENT, new StaticTableDefinition<SysPrivilegesTableInfo.PrivilegeRow>(() -> CompletableFuture.completedFuture(SysPrivilegesTableInfo.buildPrivilegesRows(roles.roles())), SysPrivilegesTableInfo.INSTANCE.expressions(), false));
        entryArray[3] = Map.entry(SysClusterTableInfo.IDENT, new StaticTableDefinition(() -> CompletableFuture.completedFuture(Collections.singletonList(null)), sysClusterTableInfo.expressions(), false));
        entryArray[4] = Map.entry(SysJobsTableInfo.IDENT, new StaticTableDefinition<JobContext>((txnCtx, user) -> CompletableFuture.completedFuture(() -> StreamSupport.stream(jobsLogs.activeJobs().spliterator(), false).filter(x -> user.isSuperUser() || user.name().equals(x.username()) || roles.hasPrivilege(user, Permission.AL, Securable.CLUSTER, null)).iterator()), SysJobsTableInfo.create(localNode).expressions(), false));
        entryArray[5] = Map.entry(SysJobsLogTableInfo.IDENT, new StaticTableDefinition<JobContextLog>((txnCtx, user) -> CompletableFuture.completedFuture(() -> StreamSupport.stream(jobsLogs.jobsLog().spliterator(), false).filter(x -> user.isSuperUser() || user.name().equals(x.username()) || roles.hasPrivilege(user, Permission.AL, Securable.CLUSTER, null)).iterator()), SysJobsLogTableInfo.create(localNode).expressions(), false));
        entryArray[6] = Map.entry(SysOperationsTableInfo.IDENT, new StaticTableDefinition<OperationContext>(() -> CompletableFuture.completedFuture(jobsLogs.activeOperations()), SysOperationsTableInfo.create(localNode).expressions(), false));
        entryArray[7] = Map.entry(SysOperationsLogTableInfo.IDENT, new StaticTableDefinition<OperationContextLog>(() -> CompletableFuture.completedFuture(jobsLogs.operationsLog()), SysOperationsLogTableInfo.INSTANCE.expressions(), false));
        entryArray[8] = Map.entry(SysChecksTableInfo.IDENT, new StaticTableDefinition<SysCheck>(sysChecker::computeResultAndGet, SysChecksTableInfo.INSTANCE.expressions(), true));
        entryArray[9] = Map.entry(SysNodeChecksTableInfo.IDENT, new StaticTableDefinition<SysNodeCheck>(() -> CompletableFuture.completedFuture(sysNodeChecks), SysNodeChecksTableInfo.INSTANCE.expressions(), true));
        entryArray[10] = Map.entry(SysRepositoriesTableInfo.IDENT, new StaticTableDefinition<Repository>(() -> CompletableFuture.completedFuture(repositoriesService.getRepositoriesList()), SysRepositoriesTableInfo.create(clusterService.getClusterSettings().maskedSettings()).expressions(), false));
        entryArray[11] = Map.entry(SysSnapshotsTableInfo.IDENT, new StaticTableDefinition<SysSnapshot>(sysSnapshots::currentSnapshots, SysSnapshotsTableInfo.INSTANCE.expressions(), true));
        entryArray[12] = Map.entry(SysSnapshotRestoreTableInfo.IDENT, new StaticTableDefinition<SysSnapshotRestoreInProgress>(() -> CompletableFuture.completedFuture(SysSnapshotRestoreTableInfo.snapshotsRestoreInProgress((RestoreInProgress)clusterService.state().custom("restore"))), SysSnapshotRestoreTableInfo.INSTANCE.expressions(), true));
        entryArray[13] = Map.entry(SysAllocationsTableInfo.IDENT, new StaticTableDefinition<SysAllocation>(() -> sysAllocations, (user, allocation) -> roles.hasAnyPrivilege((Role)user, Securable.TABLE, allocation.fqn()), SysAllocationsTableInfo.INSTANCE.expressions()));
        entryArray[14] = Map.entry(SysSummitsTableInfo.IDENT, new StaticTableDefinition<SummitsContext>(() -> CompletableFuture.completedFuture(summits), SysSummitsTableInfo.INSTANCE.expressions(), false));
        entryArray[15] = Map.entry(SysHealth.IDENT, new StaticTableDefinition<TableHealth>(() -> TableHealth.compute(clusterService.state()), SysHealth.INSTANCE.expressions(), (user, tableHealth) -> roles.hasAnyPrivilege((Role)user, Securable.TABLE, tableHealth.fqn()), true));
        entryArray[16] = Map.entry(SysMetricsTableInfo.NAME, new StaticTableDefinition<MetricsView>(() -> CompletableFuture.completedFuture(jobsLogs.metrics()), SysMetricsTableInfo.create(localNode).expressions(), false));
        entryArray[17] = Map.entry(SysSegmentsTableInfo.IDENT, new StaticTableDefinition<ShardSegment>(() -> CompletableFuture.completedFuture(shardSegmentInfos), SysSegmentsTableInfo.create(clusterService::localNode).expressions(), true));
        entryArray[18] = Map.entry(SysSessionsTableInfo.IDENT, new StaticTableDefinition<Session>((txnCtx, user) -> CompletableFuture.completedFuture(StreamSupport.stream(sessions.getActive().spliterator(), false).filter(session -> !session.isSystemSession() && (roles.hasPrivilege(user, Permission.AL, Securable.CLUSTER, null) || session.sessionSettings().sessionUser().equals(user))).toList()), SysSessionsTableInfo.create(clusterService::localNode).expressions(), false));
        this.tableDefinitions = Map.ofEntries(entryArray);
    }

    public StaticTableDefinition<?> get(RelationName relationName) {
        return this.tableDefinitions.get(relationName);
    }
}

